/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.EllipticCurveSECP256R1;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.crypto.ec.RFC7748Curve;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangePreparator<T extends ECDHClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected byte[] premasterSecret;
    protected byte[] random;
    protected final T msg;

    public ECDHClientKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing ECDHClientExchangeMessage");
        ((ECDHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.setSerializedPublicKey();
        this.prepareSerializedPublicKeyLength(this.msg);
        this.prepareAfterParse();
    }

    protected byte[] computePremasterSecret(EllipticCurve curve, Point publicKey, BigInteger privateKey) {
        if (curve instanceof RFC7748Curve) {
            RFC7748Curve rfc7748Curve = (RFC7748Curve)curve;
            return rfc7748Curve.computeSharedSecretFromDecodedPoint((BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), publicKey);
        }
        Point sharedPoint = curve.mult(privateKey, publicKey);
        if (sharedPoint == null) {
            LOGGER.warn("Computed null shared point. Using basepoint instead");
            sharedPoint = curve.getBasePoint();
        }
        if (sharedPoint.isAtInfinity()) {
            LOGGER.warn("Computed shared secrets as point in infinity. Using new byte[1] as PMS");
            return new byte[1];
        }
        int elementLength = DataConverter.bigIntegerToByteArray((BigInteger)sharedPoint.getFieldX().getModulus()).length;
        return DataConverter.bigIntegerToNullPaddedByteArray((BigInteger)sharedPoint.getFieldX().getData(), (int)elementLength);
    }

    protected void prepareSerializedPublicKeyLength(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("SerializedPublicKeyLength: {}", ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void preparePremasterSecret(T msg) {
        ((ECDHClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: {}", ((ECDHClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue());
    }

    protected void prepareClientServerRandom(T msg) {
        this.random = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((ECDHClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.random);
        LOGGER.debug("ClientServerRandom: {}", ((ECDHClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue());
    }

    @Override
    public void prepareAfterParse() {
        EllipticCurve curve;
        ((ECDHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        NamedGroup usedGroup = this.getSuitableNamedGroup();
        LOGGER.debug("PMS used Group: {}", (Object)usedGroup.name());
        if (((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey() == null) {
            this.setComputationPrivateKey(this.msg);
        }
        CyclicGroup group = usedGroup.getGroupParameters().getGroup();
        Point publicKey = this.chooser.getConnectionEndType() == ConnectionEndType.SERVER ? PointFormatter.formatFromByteArray(usedGroup.getGroupParameters(), (byte[])((byte[])((ClientKeyExchangeMessage)this.msg).getPublicKey().getValue())) : this.chooser.getEcKeyExchangePeerPublicKey();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        this.premasterSecret = this.computePremasterSecret(curve, publicKey, (BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue());
        this.preparePremasterSecret(this.msg);
    }

    private void setSerializedPublicKey() {
        byte[] publicKeyBytes;
        EllipticCurve curve;
        NamedGroup usedGroup = this.getSuitableNamedGroup();
        CyclicGroup group = usedGroup.getGroupParameters().getGroup();
        if (group instanceof EllipticCurve) {
            curve = (EllipticCurve)group;
        } else {
            LOGGER.warn("Selected group is not an EllipticCurve. Using SECP256R1");
            curve = new EllipticCurveSECP256R1();
        }
        LOGGER.debug("PublicKey used Group: {}", (Object)usedGroup.name());
        ECPointFormat pointFormat = this.chooser.getConfig().getDefaultSelectedPointFormat();
        LOGGER.debug("EC Point format: {}", (Object)pointFormat.name());
        this.setComputationPrivateKey(this.msg);
        BigInteger privateKey = (BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue();
        if (curve instanceof RFC7748Curve) {
            RFC7748Curve rfcCurve = (RFC7748Curve)curve;
            publicKeyBytes = rfcCurve.computePublicKey(privateKey);
        } else {
            Point publicKey = curve.mult(privateKey, curve.getBasePoint());
            ((ECDHClientKeyExchangeMessage)this.msg).getComputations().setPublicKeyX(publicKey.getFieldX().getData());
            ((ECDHClientKeyExchangeMessage)this.msg).getComputations().setPublicKeyY(publicKey.getFieldY().getData());
            publicKey = curve.getPoint((BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPublicKeyX().getValue(), (BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPublicKeyY().getValue());
            publicKeyBytes = PointFormatter.formatToByteArray(usedGroup.getGroupParameters(), (Point)publicKey, (PointFormat)pointFormat.getFormat());
        }
        ((ClientKeyExchangeMessage)this.msg).setPublicKey(publicKeyBytes);
    }

    private NamedGroup getSuitableNamedGroup() {
        NamedGroup usedGroup = this.chooser.getSelectedNamedGroup();
        if (!usedGroup.isEcGroup() || usedGroup.isGost()) {
            usedGroup = NamedGroup.SECP256R1;
            LOGGER.warn("Selected NamedGroup {} is not suitable for ECDHClientKeyExchange message. Using {} instead.", (Object)this.chooser.getSelectedNamedGroup(), (Object)usedGroup);
        }
        return usedGroup;
    }

    protected void setComputationPrivateKey(T msg) {
        LOGGER.debug("Preparing client key");
        ((ECDHClientKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getEcKeyExchangePrivateKey());
        LOGGER.debug("Computation PrivateKey: {}", ((ECDHClientKeyExchangeMessage)msg).getComputations().getPrivateKey().getValue());
    }
}

