/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.FfdhGroupParameters;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.selection.SignatureAndHashAlgorithmSelector;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DHEServerKeyExchangePreparator<T extends DHEServerKeyExchangeMessage>
extends ServerKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected BigInteger publicKey;
    protected SignatureAndHashAlgorithm selectedSignatureHashAlgo;
    protected byte[] signature;
    protected final T msg;

    public DHEServerKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        if (this.chooser.getSelectedCipherSuite().isExport()) {
            this.setDheExportParams();
        } else {
            this.setDheParams();
        }
        this.preparePublicKey(this.msg);
        this.prepareDheParams();
        this.selectedSignatureHashAlgo = SignatureAndHashAlgorithmSelector.selectSignatureAndHashAlgorithm(this.chooser, false);
        this.prepareSignatureAndHashAlgorithm(this.msg);
        this.signature = this.generateSignature(this.selectedSignatureHashAlgo, this.generateToBeSigned());
        this.prepareSignature(this.msg);
        this.prepareSignatureLength(this.msg);
    }

    protected void setDheParams() {
        ((DHEServerKeyExchangeMessage)this.msg).prepareKeyExchangeComputations();
        NamedGroup ffdhGroup = this.getMatchingNamedGroup();
        if (ffdhGroup == null) {
            this.setComputedGenerator(this.msg);
            this.setComputedModulus(this.msg);
        } else {
            this.setNamedGroupParameters(this.msg, ffdhGroup);
        }
        this.setComputedPrivateKey(this.msg);
    }

    protected void setDheExportParams() {
        ((DHEServerKeyExchangeMessage)this.msg).prepareKeyExchangeComputations();
        ((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().setGenerator(this.chooser.getConfig().getDefaultServerDhExportGenerator());
        LOGGER.debug("Generator: {}", ((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getGenerator().getValue());
        ((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().setModulus(this.chooser.getConfig().getDefaultServerDhExportModulus());
        LOGGER.debug("Modulus: {}", ((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getModulus().getValue());
        ((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().setPrivateKey(this.chooser.getConfig().getDefaultServerDhExportPrivateKey());
        LOGGER.debug("PrivateKey: {}", ((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getPrivateKey().getValue());
    }

    protected void prepareDheParams() {
        this.prepareModulus(this.msg);
        this.prepareModulusLength(this.msg);
        this.prepareGenerator(this.msg);
        this.prepareGeneratorLength(this.msg);
        this.prepareClientServerRandom(this.msg);
        this.preparePublicKeyLength(this.msg);
    }

    protected byte[] generateToBeSigned() {
        byte[] dhParams = DataConverter.concatenate((byte[][])new byte[][]{DataConverter.intToBytes((int)((Integer)((DHEServerKeyExchangeMessage)this.msg).getModulusLength().getValue()), (int)2), (byte[])((DHEServerKeyExchangeMessage)this.msg).getModulus().getValue(), DataConverter.intToBytes((int)((Integer)((DHEServerKeyExchangeMessage)this.msg).getGeneratorLength().getValue()), (int)2), (byte[])((DHEServerKeyExchangeMessage)this.msg).getGenerator().getValue(), DataConverter.intToBytes((int)((Integer)((ServerKeyExchangeMessage)this.msg).getPublicKeyLength().getValue()), (int)2), (byte[])((ServerKeyExchangeMessage)this.msg).getPublicKey().getValue()});
        return DataConverter.concatenate((byte[][])new byte[][]{(byte[])((DHEServerKeyExchangeMessage)this.msg).getKeyExchangeComputations().getClientServerRandom().getValue(), dhParams});
    }

    protected void prepareGenerator(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setGenerator(((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getGenerator().getByteArray());
        LOGGER.debug("Generator: {}", ((DHEServerKeyExchangeMessage)msg).getGenerator().getValue());
    }

    protected void prepareModulus(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setModulus(((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getModulus().getByteArray());
        LOGGER.debug("Modulus: {}", ((DHEServerKeyExchangeMessage)msg).getModulus().getValue());
    }

    protected void prepareGeneratorLength(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setGeneratorLength(((byte[])((DHEServerKeyExchangeMessage)msg).getGenerator().getValue()).length);
        LOGGER.debug("Generator Length: {}", ((DHEServerKeyExchangeMessage)msg).getGeneratorLength().getValue());
    }

    protected void prepareModulusLength(T msg) {
        ((DHEServerKeyExchangeMessage)msg).setModulusLength(((byte[])((DHEServerKeyExchangeMessage)msg).getModulus().getValue()).length);
        LOGGER.debug("Modulus Length: {}", ((DHEServerKeyExchangeMessage)msg).getModulusLength().getValue());
    }

    protected void preparePublicKey(T msg) {
        BigInteger publicKey = this.chooser.getServerEphemeralDhPublicKey();
        try {
            BigInteger generator = (BigInteger)((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getGenerator().getValue();
            publicKey = generator.modPow((BigInteger)((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getPrivateKey().getValue(), (BigInteger)((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getModulus().getValue());
        }
        catch (Exception e) {
            LOGGER.warn("Could not compute public key", (Throwable)e);
        }
        ((ServerKeyExchangeMessage)msg).setPublicKey(DataConverter.bigIntegerToByteArray((BigInteger)publicKey));
        LOGGER.debug("PublicKey: {}", ((ServerKeyExchangeMessage)msg).getPublicKey().getValue());
    }

    protected void preparePublicKeyLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ServerKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: {}", ((ServerKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void setComputedPrivateKey(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().setPrivateKey(this.chooser.getServerEphemeralDhPrivateKey());
        LOGGER.debug("PrivateKey: {}", ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getPrivateKey().getValue());
    }

    protected void setComputedModulus(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().setModulus(this.chooser.getServerEphemeralDhModulus());
        LOGGER.debug("Modulus used for Computations: {}", (Object)((BigInteger)((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getModulus().getValue()).toString(16));
    }

    protected void setComputedGenerator(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().setGenerator(this.chooser.getServerEphemeralDhGenerator());
        LOGGER.debug("Generator used for Computations: {}", (Object)((BigInteger)((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getGenerator().getValue()).toString(16));
    }

    protected void prepareSignatureAndHashAlgorithm(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureAndHashAlgorithm(this.selectedSignatureHashAlgo.getByteValue());
        LOGGER.debug("SignatureAlgorithm: {}", ((ServerKeyExchangeMessage)msg).getSignatureAndHashAlgorithm().getValue());
    }

    protected void prepareClientServerRandom(T msg) {
        ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().setClientServerRandom(DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()}));
        LOGGER.debug("ClientServerRandom: {}", ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().getClientServerRandom().getValue());
    }

    protected void prepareSignature(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignature(this.signature);
        LOGGER.debug("Signature: {}", ((ServerKeyExchangeMessage)msg).getSignature().getValue());
    }

    protected void prepareSignatureLength(T msg) {
        ((ServerKeyExchangeMessage)msg).setSignatureLength(((byte[])((ServerKeyExchangeMessage)msg).getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: {}", ((ServerKeyExchangeMessage)msg).getSignatureLength().getValue());
    }

    private void setNamedGroupParameters(T msg, NamedGroup chosenGroup) {
        LOGGER.debug("Negotiating NamedGroup {} for Server Key Exchange message", (Object)chosenGroup.name());
        FfdhGroupParameters ffdhGroup = (FfdhGroupParameters)chosenGroup.getGroupParameters();
        ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().setGenerator(ffdhGroup.getGenerator());
        ((DHEServerKeyExchangeMessage)msg).getKeyExchangeComputations().setModulus(ffdhGroup.getModulus());
    }

    private NamedGroup getMatchingNamedGroup() {
        if (this.chooser.getContext().getTlsContext().getClientNamedGroupsList() != null) {
            for (NamedGroup serverGroup : this.chooser.getConfig().getDefaultServerNamedGroups()) {
                if (!serverGroup.isDhGroup() || !this.chooser.getContext().getTlsContext().getClientNamedGroupsList().contains((Object)serverGroup)) continue;
                return serverGroup;
            }
        } else if (this.chooser.getConfig().getDefaultSelectedNamedGroup().isDhGroup()) {
            return this.chooser.getConfig().getDefaultSelectedNamedGroup();
        }
        return null;
    }
}

