/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.BigIntegers;

public class DHClientKeyExchangePreparator<T extends DHClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected BigInteger clientPublicKey;
    protected byte[] premasterSecret;
    protected byte[] random;
    protected byte[] masterSecret;
    protected final T msg;

    public DHClientKeyExchangePreparator(Chooser chooser, T msg) {
        super(chooser, msg);
        this.msg = msg;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing DHClientExchangeMessage");
        ((DHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        this.setComputationGenerator(this.msg);
        this.setComputationModulus(this.msg);
        this.setComputationPrivateKey(this.msg);
        this.clientPublicKey = this.calculatePublicKey((BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getGenerator().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue());
        this.preparePublicKey(this.msg);
        this.preparePublicKeyLength(this.msg);
        this.setComputationPublicKey(this.msg);
        this.premasterSecret = this.calculatePremasterSecret((BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPublicKey().getValue());
        this.preparePremasterSecret(this.msg);
    }

    protected BigInteger calculatePublicKey(BigInteger generator, BigInteger modulus, BigInteger privateKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 0) {
            LOGGER.warn("Modulus is ZERO. Returning 0 publicKey");
            return BigInteger.ZERO;
        }
        return generator.modPow(privateKey.abs(), modulus.abs());
    }

    protected byte[] calculatePremasterSecret(BigInteger modulus, BigInteger privateKey, BigInteger publicKey) {
        if (modulus.compareTo(BigInteger.ZERO) == 0) {
            LOGGER.warn("Modulus is ZERO. Returning empty premaster Secret");
            return new byte[0];
        }
        return BigIntegers.asUnsignedByteArray((BigInteger)publicKey.modPow(privateKey.abs(), modulus.abs()));
    }

    protected void setComputationGenerator(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setGenerator(this.chooser.getDhKeyExchangeGenerator());
        LOGGER.debug("Generator: {}", ((DHClientKeyExchangeMessage)msg).getComputations().getGenerator().getValue());
    }

    protected void setComputationModulus(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setModulus(this.chooser.getDhKeyExchangeModulus());
        LOGGER.debug("Modulus: {}", ((DHClientKeyExchangeMessage)msg).getComputations().getModulus().getValue());
    }

    protected void preparePremasterSecret(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        this.premasterSecret = (byte[])((DHClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue();
        LOGGER.debug("PremasterSecret: {}", ((DHClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue());
    }

    protected void preparePublicKey(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKey(DataConverter.bigIntegerToByteArray((BigInteger)this.clientPublicKey));
        LOGGER.debug("PublicKey: {}", ((ClientKeyExchangeMessage)msg).getPublicKey().getValue());
    }

    protected void preparePublicKeyLength(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: {}", ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void prepareClientServerRandom(T msg) {
        this.random = DataConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((DHClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.random);
        this.random = (byte[])((DHClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue();
        LOGGER.debug("ClientServerRandom: {}", ((DHClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue());
    }

    @Override
    public void prepareAfterParse() {
        ((DHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        this.setComputationGenerator(this.msg);
        this.setComputationModulus(this.msg);
        this.setComputationPrivateKey(this.msg);
        this.setComputationPublicKey(this.msg);
        this.premasterSecret = this.calculatePremasterSecret((BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getModulus().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), (BigInteger)((DHClientKeyExchangeMessage)this.msg).getComputations().getPublicKey().getValue());
        this.preparePremasterSecret(this.msg);
    }

    protected void setComputationPrivateKey(T msg) {
        ((DHClientKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getDhKeyExchangePrivateKey());
        LOGGER.debug("Computation PrivateKey: {}", (Object)((BigInteger)((DHClientKeyExchangeMessage)msg).getComputations().getPrivateKey().getValue()).toString());
    }

    protected void setComputationPublicKey(T msg) {
        if (this.chooser.getConnectionEndType() == ConnectionEndType.SERVER) {
            ((DHClientKeyExchangeMessage)msg).getComputations().setPublicKey(new BigInteger(1, (byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()));
        } else {
            ((DHClientKeyExchangeMessage)msg).getComputations().setPublicKey(this.chooser.getDhKeyExchangePeerPublicKey());
        }
        LOGGER.debug("Computation (peer) PublicKey: {}", (Object)((BigInteger)((DHClientKeyExchangeMessage)msg).getComputations().getPublicKey().getValue()).toString());
    }
}

