/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.protocol.message.CertificateStatusMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusPreparator
extends HandshakeMessagePreparator<CertificateStatusMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TYPE_OCSP = 1;
    private final CertificateStatusMessage msg;

    public CertificateStatusPreparator(Chooser chooser, CertificateStatusMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing CertificateStatusMessage");
        LOGGER.debug("Note: This is not properly implemented yet. Will use hardcoded message with empty content.");
        this.prepareCertificateStatusType();
        this.prepareOcspResponseLength();
        this.prepareOcspResponseBytes();
    }

    private void prepareCertificateStatusType() {
        this.msg.setCertificateStatusType(1);
        LOGGER.debug("CertificateStatusType: {}", this.msg.getCertificateStatusType().getValue());
    }

    private void prepareOcspResponseLength() {
        this.msg.setOcspResponseLength(0);
        LOGGER.debug("OCSPResponseLength: {}", (Object)this.msg.getOcspResponseLength());
    }

    private void prepareOcspResponseBytes() {
        this.msg.setOcspResponseBytes(new byte[0]);
        LOGGER.debug("OCSPResponseBytes: {}", (Object)this.msg.getOcspResponseBytes());
    }
}

