/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestPreparator
extends HandshakeMessagePreparator<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] certTypes;
    private byte[] sigHashAlgos;
    private final CertificateRequestMessage msg;

    public CertificateRequestPreparator(Chooser chooser, CertificateRequestMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing CertificateRequestMessage");
        if (this.chooser.getSelectedProtocolVersion().is13()) {
            this.prepareCertificateRequestContext(this.msg);
            this.prepareCertificateRequestContextLength(this.msg);
            this.prepareExtensions();
            this.prepareExtensionLength();
        } else {
            this.certTypes = this.convertClientCertificateTypes(this.chooser.getConfig().getClientCertificateTypes());
            this.prepareClientCertificateTypes(this.certTypes, this.msg);
            this.prepareClientCertificateTypesCount(this.msg);
            this.prepareDistinguishedNames(this.msg);
            this.prepareDistinguishedNamesLength(this.msg);
            this.sigHashAlgos = this.convertSigAndHashAlgos(this.chooser.getServerSupportedSignatureAndHashAlgorithms());
            this.prepareSignatureHashAlgorithms(this.msg);
            this.prepareSignatureHashAlgorithmsLength(this.msg);
        }
    }

    private byte[] convertClientCertificateTypes(List<ClientCertificateType> typeList) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (ClientCertificateType type : typeList) {
            stream.write(type.getArrayValue());
        }
        return stream.toByteArray();
    }

    private byte[] convertSigAndHashAlgos(List<SignatureAndHashAlgorithm> algoList) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (SignatureAndHashAlgorithm algo : algoList) {
            stream.write(algo.getByteValue());
        }
        return stream.toByteArray();
    }

    private void prepareClientCertificateTypes(byte[] certTypes, CertificateRequestMessage msg) {
        msg.setClientCertificateTypes(certTypes);
        LOGGER.debug("ClientCertificateTypes: {}", msg.getClientCertificateTypes().getValue());
    }

    private void prepareClientCertificateTypesCount(CertificateRequestMessage msg) {
        msg.setClientCertificateTypesCount(((byte[])msg.getClientCertificateTypes().getValue()).length);
        LOGGER.debug("ClientCertificateTypesCount: " + String.valueOf(msg.getClientCertificateTypesCount().getValue()));
    }

    private void prepareDistinguishedNames(CertificateRequestMessage msg) {
        msg.setDistinguishedNames(this.chooser.getConfig().getDistinguishedNames());
        LOGGER.debug("DistinguishedNames: {}", msg.getDistinguishedNames().getValue());
    }

    private void prepareDistinguishedNamesLength(CertificateRequestMessage msg) {
        msg.setDistinguishedNamesLength(((byte[])msg.getDistinguishedNames().getValue()).length);
        LOGGER.debug("DistinguishedNamesLength: {}", msg.getDistinguishedNamesLength().getValue());
    }

    private void prepareSignatureHashAlgorithms(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithms(this.sigHashAlgos);
        LOGGER.debug("SignatureHashAlgorithms: {}", msg.getSignatureHashAlgorithms().getValue());
    }

    private void prepareSignatureHashAlgorithmsLength(CertificateRequestMessage msg) {
        msg.setSignatureHashAlgorithmsLength(((byte[])msg.getSignatureHashAlgorithms().getValue()).length);
        LOGGER.debug("SignatureHashAlgorithmsLength: " + String.valueOf(msg.getSignatureHashAlgorithmsLength().getValue()));
    }

    private void prepareCertificateRequestContext(CertificateRequestMessage msg) {
        msg.setCertificateRequestContext(this.chooser.getConfig().getDefaultCertificateRequestContext());
        LOGGER.debug("CertificateRequestContext: {}", msg.getCertificateRequestContext().getValue());
    }

    private void prepareCertificateRequestContextLength(CertificateRequestMessage msg) {
        msg.setCertificateRequestContextLength(((byte[])msg.getCertificateRequestContext().getValue()).length);
        LOGGER.debug("CertificateRequestContextLength: " + String.valueOf(msg.getCertificateRequestContextLength().getValue()));
    }
}

