/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrtpExtensionParser
extends ExtensionParser<SrtpExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrtpExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SrtpExtensionMessage msg) {
        msg.setSrtpProtectionProfilesLength(this.parseIntField(2));
        LOGGER.debug("Parsed the srtp protection profiles length of {}", msg.getSrtpProtectionProfilesLength().getValue());
        msg.setSrtpProtectionProfiles(this.parseByteArrayField((Integer)msg.getSrtpProtectionProfilesLength().getValue()));
        LOGGER.debug("Parsed the srtp protection profiles {}", (Object)msg.getSrtpProtectionProfiles());
        msg.setSrtpMkiLength(this.parseIntField(1));
        LOGGER.debug("Parsed the srtp mki length of : {}", msg.getSrtpMkiLength().getValue());
        msg.setSrtpMki(this.parseByteArrayField((Integer)msg.getSrtpMkiLength().getValue()));
        LOGGER.debug("Parsed the srtp mki {}", (Object)msg.getSrtpMki());
    }
}

