/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.EchConfigVersion;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeKeyDerivationFunction;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeKeyEncapsulationMechanism;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ech.HpkeCipherSuite;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionListParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EchConfigParser
extends Parser<List<EchConfig>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext tlsContext;

    public EchConfigParser(InputStream inputStream, TlsContext tlsContext) {
        super(inputStream);
        this.tlsContext = tlsContext;
    }

    @Override
    public void parse(List<EchConfig> echConfigs) {
        int configsLength = this.parseIntField(2);
        int configBytesStart = 2;
        while (this.getAlreadyParsed().length < configsLength) {
            EchConfig echConfig = new EchConfig();
            try {
                this.parseVersion(echConfig);
                this.parseLength(echConfig);
                this.parseEchContents(echConfig);
                echConfig.setEchConfigBytes(Arrays.copyOfRange(this.getAlreadyParsed(), configBytesStart, this.getAlreadyParsed().length));
                echConfigs.add(echConfig);
                configBytesStart += this.getAlreadyParsed().length;
            }
            catch (ParserException e) {
                LOGGER.warn("Error during EchConfig parsing: ", (Throwable)e);
            }
        }
    }

    private void parseVersion(EchConfig echConfig) {
        byte[] version = this.parseByteArrayField(2);
        echConfig.setConfigVersion(EchConfigVersion.getEnumByByte(version));
        LOGGER.debug("Version: {}", (Object)echConfig.getConfigVersion());
    }

    private void parseLength(EchConfig echConfig) {
        int length = this.parseIntField(2);
        echConfig.setLength(length);
        LOGGER.debug("Length: {}", (Object)echConfig.getLength());
    }

    private void parseEchContents(EchConfig echConfig) {
        switch (echConfig.getConfigVersion()) {
            case DRAFT_FF03: {
                this.parsePublicName(echConfig, false);
                this.parsePublicKey(echConfig);
                this.parseKemId(echConfig);
                this.parseCipherSuites(echConfig);
                this.parseMaximumNameLength(echConfig);
                this.parseExtensions(echConfig);
                break;
            }
            case DRAFT_FF07: 
            case DRAFT_FF08: 
            case DRAFT_FF09: {
                this.parsePublicName(echConfig, false);
                this.parsePublicKey(echConfig);
                this.parseKemId(echConfig);
                this.parseHPKECipherSuites(echConfig);
                this.parseMaximumNameLength(echConfig);
                this.parseExtensions(echConfig);
                break;
            }
            case DRAFT_FF0A: 
            case DRAFT_FF0B: 
            case DRAFT_FF0C: 
            case DRAFT_FF0D: {
                this.parseHpkeKeyConfig(echConfig);
                this.parseMaximumNameLength(echConfig);
                this.parsePublicName(echConfig, true);
                this.parseExtensions(echConfig);
            }
        }
    }

    private void parseMaximumNameLength(EchConfig echConfig) {
        int length = this.parseIntField(1);
        echConfig.setMaximumNameLength(length);
        LOGGER.debug("Maximum Name Length: {}", (Object)echConfig.getMaximumNameLength());
    }

    private void parsePublicName(EchConfig echConfig, boolean parseShort) {
        int publicNameLen = parseShort ? this.parseIntField(1) : this.parseIntField(2);
        byte[] publicName = this.parseByteArrayField(publicNameLen);
        echConfig.setPublicDomainName(publicName);
        LOGGER.debug("Public Name: {}", (Object)echConfig.getPublicDomainName());
    }

    private void parseExtensions(EchConfig echConfig) {
        int extensionsLength = this.parseIntField(2);
        byte[] extensionBytes = this.parseByteArrayField(extensionsLength);
        ByteArrayInputStream innerStream = new ByteArrayInputStream(extensionBytes);
        ExtensionListParser parser = new ExtensionListParser(innerStream, this.tlsContext, false);
        LinkedList<ExtensionMessage> extensionMessages = new LinkedList<ExtensionMessage>();
        parser.parse((List<ExtensionMessage>)extensionMessages);
        echConfig.getExtensions().addAll(extensionMessages);
    }

    private void parseHpkeKeyConfig(EchConfig echConfig) {
        this.parseConfigId(echConfig);
        this.parseKemId(echConfig);
        this.parsePublicKey(echConfig);
        this.parseHPKECipherSuites(echConfig);
    }

    private void parseConfigId(EchConfig echConfig) {
        int configId = this.parseIntField(1);
        echConfig.setConfigId(configId);
        LOGGER.debug("Config ID: {}", (Object)echConfig.getConfigId());
    }

    private void parseKemId(EchConfig echConfig) {
        byte[] kemId = this.parseByteArrayField(2);
        HpkeKeyEncapsulationMechanism kem = HpkeKeyEncapsulationMechanism.getEnumByByte(kemId);
        echConfig.setKem(kem);
        LOGGER.debug("KEM ID: {}", (Object)echConfig.getKem());
    }

    private void parsePublicKey(EchConfig echConfig) {
        int publicKeyLen = this.parseIntField(2);
        byte[] publicKey = this.parseByteArrayField(publicKeyLen);
        echConfig.setHpkePublicKey(publicKey);
        LOGGER.debug("Public Key: {}", (Object)echConfig.getHpkePublicKey());
    }

    private void parseHPKECipherSuites(EchConfig echConfig) {
        int ciphersuitesLen = this.parseIntField(2);
        LinkedList<HpkeCipherSuite> hpkeCipherSuites = new LinkedList<HpkeCipherSuite>();
        for (int i = 0; i < ciphersuitesLen; i += 4) {
            HpkeKeyDerivationFunction hkdfAlgorithm = this.parseKdfId();
            HpkeAeadFunction aeadAlgorithm = this.parseAEADId();
            hpkeCipherSuites.add(new HpkeCipherSuite(hkdfAlgorithm, aeadAlgorithm));
        }
        echConfig.setHpkeCipherSuites(hpkeCipherSuites);
    }

    private HpkeKeyDerivationFunction parseKdfId() {
        byte[] kdfId = this.parseByteArrayField(2);
        return HpkeKeyDerivationFunction.getEnumByByte(kdfId);
    }

    private HpkeAeadFunction parseAEADId() {
        byte[] aeadId = this.parseByteArrayField(2);
        return HpkeAeadFunction.getEnumByByte(aeadId);
    }

    private void parseCipherSuites(EchConfig echConfig) {
        int cipherSuitesLen = this.parseIntField(2);
        byte[] cipherSuitesBytes = this.parseByteArrayField(cipherSuitesLen);
        List<CipherSuite> cipherSuites = CipherSuite.getCipherSuites(cipherSuitesBytes);
        echConfig.setCipherSuites(cipherSuites);
    }
}

