/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CookieExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CookieExtensionParser
extends ExtensionParser<CookieExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CookieExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(CookieExtensionMessage msg) {
        LOGGER.debug("Parsing CookieExtensionMessage");
        this.parseCookieLength(msg);
        this.parseCookie(msg);
    }

    private void parseCookieLength(CookieExtensionMessage msg) {
        msg.setCookieLength(this.parseIntField(2));
        LOGGER.debug("Cookie length: {}", msg.getCookieLength().getValue());
    }

    private void parseCookie(CookieExtensionMessage msg) {
        msg.setCookie(this.parseByteArrayField((Integer)msg.getCookieLength().getValue()));
        LOGGER.debug("Cookie: {}", msg.getCookie().getValue());
    }
}

