/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.alpn.AlpnEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.AlpnEntryParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;

public class AlpnExtensionParser
extends ExtensionParser<AlpnExtensionMessage> {
    public AlpnExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(AlpnExtensionMessage msg) {
        msg.setProposedAlpnProtocolsLength(this.parseIntField(2));
        byte[] proposedProtocol = this.parseByteArrayField((Integer)msg.getProposedAlpnProtocolsLength().getValue());
        msg.setProposedAlpnProtocols(proposedProtocol);
        LinkedList<AlpnEntry> entryList = new LinkedList<AlpnEntry>();
        ByteArrayInputStream innerStream = new ByteArrayInputStream(proposedProtocol);
        while (innerStream.available() > 0) {
            AlpnEntryParser parser = new AlpnEntryParser(innerStream);
            AlpnEntry entry = new AlpnEntry();
            parser.parse(entry);
            entryList.add(entry);
        }
        msg.setAlpnEntryList(entryList);
    }
}

