/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.SupplementalDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.supplementaldata.SupplementalDataEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import de.rub.nds.tlsattacker.core.protocol.parser.supplementaldata.SupplementalDataEntryParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupplementalDataParser
extends HandshakeMessageParser<SupplementalDataMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SupplementalDataParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SupplementalDataMessage msg) {
        LOGGER.debug("Parsing SupplementalDataMessage");
        this.parseSupplementalDataLength(msg);
        this.parseSupplementalDataBytes(msg);
        this.parseSupplementalDataEntries(msg);
    }

    private void parseSupplementalDataLength(SupplementalDataMessage msg) {
        msg.setSupplementalDataLength(this.parseIntField(3));
        LOGGER.debug("SupplementalDataLength: {}", msg.getSupplementalDataLength().getValue());
    }

    private void parseSupplementalDataBytes(SupplementalDataMessage msg) {
        msg.setSupplementalDataBytes(this.parseByteArrayField((Integer)msg.getSupplementalDataLength().getValue()));
        LOGGER.debug("SupplementalDataBytes: {}", msg.getSupplementalDataBytes().getValue());
    }

    private void parseSupplementalDataEntries(SupplementalDataMessage msg) {
        LinkedList<SupplementalDataEntry> entryList = new LinkedList<SupplementalDataEntry>();
        ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])msg.getSupplementalDataBytes().getValue());
        while (innerStream.available() > 0) {
            SupplementalDataEntryParser parser = new SupplementalDataEntryParser(innerStream);
            SupplementalDataEntry entry = new SupplementalDataEntry();
            parser.parse(entry);
            entryList.add(entry);
        }
        msg.setEntries(entryList);
    }
}

