/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;

public abstract class ServerKeyExchangeParser<T extends ServerKeyExchangeMessage>
extends HandshakeMessageParser<T> {
    private KeyExchangeAlgorithm keyExchangeAlgorithm;

    public ServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
        this.keyExchangeAlgorithm = tlsContext.getChooser().getSelectedCipherSuite().getKeyExchangeAlgorithm();
    }

    protected KeyExchangeAlgorithm getKeyExchangeAlgorithm() {
        return this.keyExchangeAlgorithm;
    }

    protected void setKeyExchangeAlgorithm(KeyExchangeAlgorithm keyExchangeAlgorithm) {
        this.keyExchangeAlgorithm = keyExchangeAlgorithm;
    }

    protected boolean isTLS12() {
        return this.getVersion() == ProtocolVersion.TLS12;
    }

    protected boolean isDTLS12() {
        return this.getVersion() == ProtocolVersion.DTLS12;
    }

    protected boolean shouldParseSignature() {
        KeyExchangeAlgorithm keyExchangeAlgorithm = this.getKeyExchangeAlgorithm();
        if (keyExchangeAlgorithm == null) {
            return true;
        }
        return !keyExchangeAlgorithm.isAnon();
    }
}

