/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HelloMessageParser;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHelloParser
extends HelloMessageParser<ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerHelloParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    protected void parseSelectedCipherSuite(ServerHelloMessage msg) {
        msg.setSelectedCipherSuite(this.parseByteArrayField(2));
    }

    protected void parseSelectedCompressionMethod(ServerHelloMessage msg) {
        msg.setSelectedCompressionMethod(this.parseByteField(1));
    }

    @Override
    public void parse(ServerHelloMessage msg) {
        LOGGER.debug("Parsing ServerHelloMessage");
        this.parseProtocolVersion(msg);
        ProtocolVersion version = ProtocolVersion.getProtocolVersion((byte[])msg.getProtocolVersion().getValue());
        if (version != null) {
            this.setVersion(version);
        }
        this.parseRandom(msg);
        msg.setHelloRetryRequest(Arrays.equals((byte[])msg.getRandom().getValue(), ServerHelloMessage.getHelloRetryRequestRandom()));
        this.parseSessionIDLength(msg);
        this.parseSessionID(msg);
        this.parseSelectedCipherSuite(msg);
        this.parseSelectedCompressionMethod(msg);
        LOGGER.trace("Checking for ExtensionLength Field");
        if (this.hasExtensionLengthField()) {
            LOGGER.trace("Parsing ExtensionLength field");
            this.parseExtensionLength(msg);
            this.parseExtensionBytes(msg, msg.hasTls13HelloRetryRequestRandom());
        }
    }
}

