/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.DHClientKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDhClientKeyExchangeParser
extends DHClientKeyExchangeParser<PskDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskDhClientKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PskDhClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKDHClientKeyExchangeMessage");
        this.parsePskIdentityLength(msg);
        this.parsePskIdentity(msg);
        super.parseDhParams(msg);
    }

    private void parsePskIdentityLength(PskDhClientKeyExchangeMessage msg) {
        msg.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("PSK-IdentityLength: {}", msg.getIdentityLength().getValue());
    }

    private void parsePskIdentity(PskDhClientKeyExchangeMessage msg) {
        msg.setIdentity(this.parseByteArrayField((Integer)msg.getIdentityLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: {}", msg.getIdentity().getValue());
    }
}

