/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ServerKeyExchangeParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDServerKeyExchangeParser
extends ServerKeyExchangeParser<PWDServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDServerKeyExchangeParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(PWDServerKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PWDServerKeyExchangeMessage");
        this.parseSaltLength(msg);
        this.parseSalt(msg);
        this.parseCurveType(msg);
        this.parseNamedGroup(msg);
        this.parseElementLength(msg);
        this.parseElement(msg);
        this.parseScalarLength(msg);
        this.parseScalar(msg);
    }

    private void parseSaltLength(PWDServerKeyExchangeMessage msg) {
        msg.setSaltLength(this.parseIntField(1));
        LOGGER.debug("SaltLength: {}", msg.getSaltLength().getValue());
    }

    private void parseSalt(PWDServerKeyExchangeMessage msg) {
        msg.setSalt(this.parseByteArrayField((Integer)msg.getSaltLength().getValue()));
        LOGGER.debug("Salt: {}", msg.getSalt().getValue());
    }

    private void parseCurveType(PWDServerKeyExchangeMessage msg) {
        msg.setCurveType(this.parseByteField(1));
        LOGGER.debug("CurveType: {}", msg.getGroupType().getValue());
    }

    private void parseNamedGroup(PWDServerKeyExchangeMessage msg) {
        msg.setNamedGroup(this.parseByteArrayField(2));
        LOGGER.debug("NamedGroup: {}", msg.getNamedGroup().getValue());
    }

    private void parseElementLength(PWDServerKeyExchangeMessage msg) {
        msg.setElementLength(this.parseIntField(1));
        LOGGER.debug("ElementLength: {}", msg.getElementLength().getValue());
    }

    private void parseElement(PWDServerKeyExchangeMessage msg) {
        msg.setElement(this.parseByteArrayField((Integer)msg.getElementLength().getValue()));
        LOGGER.debug("Element: {}", msg.getElement().getValue());
    }

    private void parseScalarLength(PWDServerKeyExchangeMessage msg) {
        msg.setScalarLength(this.parseIntField(1));
        LOGGER.debug("ScalarLength: {}", msg.getScalarLength().getValue());
    }

    private void parseScalar(PWDServerKeyExchangeMessage msg) {
        msg.setScalar(this.parseByteArrayField((Integer)msg.getScalarLength().getValue()));
        LOGGER.debug("Scalar: {}", msg.getScalar().getValue());
    }
}

