/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelloMessageParser<T extends HelloMessage>
extends HandshakeMessageParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloMessageParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    protected boolean hasSessionID(HelloMessage message) {
        return (Integer)message.getSessionIdLength().getValue() > 0;
    }

    protected void parseProtocolVersion(HelloMessage message) {
        message.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: {}", message.getProtocolVersion().getValue());
    }

    protected void parseRandom(HelloMessage message) {
        message.setRandom(this.parseByteArrayField(32));
        LOGGER.debug("Random: {}", message.getRandom().getValue());
        message.setUnixTime(Arrays.copyOf((byte[])message.getRandom().getValue(), 4));
        LOGGER.debug("UnixTime: {}", message.getUnixTime().getValue());
    }

    protected void parseSessionIDLength(HelloMessage message) {
        message.setSessionIdLength(this.parseIntField(1));
        LOGGER.debug("SessionIDLength: {}", message.getSessionIdLength().getValue());
    }

    protected void parseSessionID(HelloMessage message) {
        message.setSessionId(this.parseByteArrayField(message.getSessionIdLength().getOriginalValue()));
        LOGGER.debug("SessionID: {}", message.getSessionId().getValue());
    }
}

