/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncryptedExtensionsParser
extends HandshakeMessageParser<EncryptedExtensionsMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EncryptedExtensionsParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(EncryptedExtensionsMessage msg) {
        LOGGER.debug("Parsing EncryptedExtensionsMessage");
        if (this.hasExtensionLengthField()) {
            this.parseExtensionLength(msg);
            if (this.hasExtensions(msg)) {
                this.parseExtensionBytes(msg, false);
            } else {
                msg.setExtensions(new ArrayList<ExtensionMessage>());
            }
        }
    }
}

