/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import de.rub.nds.tlsattacker.core.protocol.parser.cert.CertificateEntryParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateMessageParser
extends HandshakeMessageParser<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private TlsContext tlsContext;

    public CertificateMessageParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext.getChooser().getSelectedProtocolVersion(), tlsContext);
        this.tlsContext = tlsContext;
    }

    @Override
    public void parse(CertificateMessage msg) {
        LOGGER.debug("Parsing CertificateMessage");
        if (this.getVersion().is13()) {
            this.parseRequestContextLength(msg);
            this.parseRequestContextBytes(msg);
        }
        this.parseCertificatesListLength(msg);
        this.parseCertificateListBytes(msg);
        this.parseCertificateList(msg);
    }

    private void parseRequestContextLength(CertificateMessage msg) {
        msg.setRequestContextLength(this.parseIntField(1));
        LOGGER.debug("RequestContextLength: {}", (Object)msg.getRequestContextLength());
    }

    private void parseRequestContextBytes(CertificateMessage msg) {
        msg.setRequestContext(this.parseByteArrayField((Integer)msg.getRequestContextLength().getValue()));
        LOGGER.debug("RequestContextBytes: {}", (Object)msg.getRequestContext());
    }

    private void parseCertificatesListLength(CertificateMessage msg) {
        msg.setCertificatesListLength(this.parseIntField(3));
        LOGGER.debug("CertificatesListLength: {}", (Object)msg.getCertificatesListLength());
    }

    private void parseCertificateListBytes(CertificateMessage msg) {
        msg.setCertificatesListBytes(this.parseByteArrayField((Integer)msg.getCertificatesListLength().getValue()));
        LOGGER.debug("CertificatesListBytes: {}", (Object)msg.getCertificatesListBytes());
    }

    private void parseCertificateList(CertificateMessage msg) {
        CertificateEntryParser parser;
        LinkedList<CertificateEntry> entryList = new LinkedList<CertificateEntry>();
        ByteArrayInputStream innerStream = new ByteArrayInputStream((byte[])msg.getCertificatesListBytes().getValue());
        while (innerStream.available() > 0) {
            CertificateEntry entry = new CertificateEntry();
            parser = new CertificateEntryParser(innerStream, this.tlsContext);
            parser.parse(entry);
            entryList.add(entry);
        }
        msg.setCertificateEntryList(entryList);
        for (int i = entryList.size() - 1; i >= 0; --i) {
            parser = new CertificateEntryParser(null, this.tlsContext);
            parser.parseX509Certificate((CertificateEntry)((Object)entryList.get(i)));
        }
    }
}

