/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.message.AckMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AckParser
extends ProtocolMessageParser<AckMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AckParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(AckMessage ackMessage) {
        LOGGER.debug("Parsing AckMessage");
        this.parseRecordNumbersLength(ackMessage);
        this.parseRecordNumbers(ackMessage);
    }

    private void parseRecordNumbers(AckMessage ackMessage) {
        ackMessage.setRecordNumbers(new LinkedList<RecordNumber>());
        LOGGER.debug("RecordNumbers: ");
        for (int i = 0; i < (Integer)ackMessage.getRecordNumberLength().getValue(); i += 16) {
            RecordNumber recordNumber = new RecordNumber();
            recordNumber.setEpoch(this.parseBigIntField(8));
            recordNumber.setSequenceNumber(this.parseBigIntField(8));
            ackMessage.getRecordNumbers().add(recordNumber);
            LOGGER.debug("\t - {}", (Object)recordNumber);
        }
    }

    private void parseRecordNumbersLength(AckMessage ackMessage) {
        ackMessage.setRecordNumberLength(this.parseIntField(2));
        LOGGER.debug("RecordNumberLength: {}", ackMessage.getRecordNumberLength().getValue());
    }
}

