/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension.quic;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParametersExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.constants.QuicTransportParameterEntryTypes;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import java.util.Arrays;
import java.util.Objects;

public class QuicTransportParameterEntry
extends ModifiableVariableHolder {
    private QuicTransportParameterEntryTypes entryType;
    private ModifiableByteArray entryValue;
    private ModifiableByte entryLength;

    public QuicTransportParameterEntry() {
    }

    public QuicTransportParameterEntry(QuicTransportParameterEntryTypes entryType, String entryValue) {
        this.entryType = entryType;
        this.setEntryValue(DataConverter.hexStringToByteArray((String)entryValue));
        this.setEntryLength((byte)((byte[])this.entryValue.getValue()).length);
    }

    public QuicTransportParameterEntry(QuicTransportParameterEntryTypes entryType, byte[] entryValue) {
        this.entryType = entryType;
        this.setEntryValue(entryValue);
        this.setEntryLength((byte)((byte[])this.entryValue.getValue()).length);
    }

    public QuicTransportParameterEntry(QuicTransportParameterEntryTypes entryType, long entryValue) {
        this.entryType = entryType;
        this.setEntryValue(VariableLengthIntegerEncoding.encodeVariableLengthInteger(entryValue));
        this.setEntryLength((byte)((byte[])this.entryValue.getValue()).length);
    }

    public QuicTransportParameterEntryTypes getEntryType() {
        return this.entryType;
    }

    public ModifiableByteArray getEntryValue() {
        return this.entryValue;
    }

    public void setEntryValue(ModifiableByteArray entryValue) {
        this.entryValue = entryValue;
    }

    public void setEntryValue(byte[] entryValue) {
        this.entryValue = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.entryValue, (byte[])entryValue);
    }

    public ModifiableByte getEntryLength() {
        return this.entryLength;
    }

    public void setEntryLength(ModifiableByte entryLength) {
        this.entryLength = entryLength;
    }

    public void setEntryLength(byte entryLength) {
        this.entryLength = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.entryLength, (Byte)entryLength);
    }

    public void setEntryType(QuicTransportParameterEntryTypes entryType) {
        this.entryType = entryType;
    }

    public String entryValueToString() {
        switch (this.entryType) {
            case ORIGINAL_DESTINATION_CONNECTION_ID: 
            case INITIAL_SOURCE_CONNECTION_ID: 
            case RETRY_SOURCE_CONNECTION_ID: {
                return DataConverter.bytesToHexString((ModifiableByteArray)this.entryValue, (boolean)false);
            }
            case MAX_IDLE_TIMEOUT: 
            case MAX_UDP_PAYLOAD_SIZE: 
            case INITIAL_MAX_DATA: 
            case INITIAL_MAX_STREAM_DATA_BIDI_LOCAL: 
            case INITIAL_MAX_STREAM_DATA_BIDI_REMOTE: 
            case INITIAL_MAX_STREAM_DATA_UNI: 
            case INITIAL_MAX_STREAMS_BIDI: 
            case INITIAL_MAX_STREAMS_UNI: 
            case ACK_DELAY_EXPONENT: 
            case MAX_ACK_DELAY: 
            case ACTIVE_CONNECTION_ID_LIMIT: {
                return Long.toString(VariableLengthIntegerEncoding.decodeVariableLengthInteger((byte[])this.entryValue.getValue()));
            }
            case DISABLE_ACTIVE_MIGRATION: {
                return "TRUE";
            }
            case PREFERRED_ADDRESS: {
                return new QuicTransportParametersExtensionMessage.PreferredAddress((byte[])this.entryValue.getValue()).toString();
            }
        }
        return DataConverter.bytesToHexString((ModifiableByteArray)this.entryValue, (boolean)false);
    }

    public String toString() {
        return this.entryType.name() + ": " + this.entryValueToString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        QuicTransportParameterEntry that = (QuicTransportParameterEntry)((Object)o);
        if (this.entryType != that.entryType) {
            return false;
        }
        if (!Arrays.equals((byte[])this.entryValue.getValue(), (byte[])that.entryValue.getValue())) {
            return false;
        }
        return Objects.equals(this.entryLength, that.entryLength);
    }

    public int hashCode() {
        int result = this.entryType != null ? this.entryType.hashCode() : 0;
        result = 31 * result + (this.entryValue != null ? this.entryValue.hashCode() : 0);
        result = 31 * result + (this.entryLength != null ? this.entryLength.hashCode() : 0);
        return result;
    }
}

