/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.EarlyDataExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EarlyDataExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EarlyDataExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.EarlyDataExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement(name="EarlyDataExtension")
public class EarlyDataExtensionMessage
extends ExtensionMessage {
    private ModifiableInteger maxEarlyDataSize;
    private boolean newSessionTicketExtension = false;

    public EarlyDataExtensionMessage() {
        super(ExtensionType.EARLY_DATA);
    }

    public EarlyDataExtensionMessage(boolean newSessionTicketExtension) {
        super(ExtensionType.EARLY_DATA);
        this.newSessionTicketExtension = newSessionTicketExtension;
    }

    public ModifiableInteger getMaxEarlyDataSize() {
        return this.maxEarlyDataSize;
    }

    public void setMaxEarlyDataSize(ModifiableInteger maxEarlyDataSize) {
        this.maxEarlyDataSize = maxEarlyDataSize;
    }

    public void setMaxEarlyDataSize(int maxEarlyDataSize) {
        this.maxEarlyDataSize = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.maxEarlyDataSize, (Integer)maxEarlyDataSize);
    }

    public boolean isNewSessionTicketExtension() {
        return this.newSessionTicketExtension;
    }

    public void setNewSessionTicketExtension(boolean newSessionTicketExtension) {
        this.newSessionTicketExtension = newSessionTicketExtension;
    }

    @Override
    public EarlyDataExtensionParser getParser(Context context, InputStream stream) {
        return new EarlyDataExtensionParser(stream, context.getTlsContext());
    }

    @Override
    public EarlyDataExtensionPreparator getPreparator(Context context) {
        return new EarlyDataExtensionPreparator(context.getChooser(), this);
    }

    @Override
    public EarlyDataExtensionSerializer getSerializer(Context context) {
        return new EarlyDataExtensionSerializer(this);
    }

    @Override
    public EarlyDataExtensionHandler getHandler(Context context) {
        return new EarlyDataExtensionHandler(context.getTlsContext());
    }
}

