/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.computations;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;
import de.rub.nds.tlsattacker.core.util.StaticTicketCrypto;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.util.DigestFactory;

public class PWDComputations
extends KeyExchangeComputations {
    public static final int MAX_HASH_ITERATIONS = 1000;
    private static final Logger LOGGER = LogManager.getLogger();
    private Point passwordElement;
    private BigInteger privateKeyScalar;

    public static Point computePasswordElement(Chooser chooser, CyclicGroup<?> group) throws CryptoException {
        int lsbY;
        byte[] base;
        MacAlgorithm randomFunction = PWDComputations.getMacAlgorithm(chooser.getSelectedCipherSuite());
        if (!(group instanceof EllipticCurve)) {
            LOGGER.debug("Can only compute the password element for elliptic curves. Returning default point");
            return new Point();
        }
        EllipticCurve curve = (EllipticCurve)group;
        byte[] salt = chooser.getContext().getTlsContext().getServerPWDSalt();
        if (salt == null && chooser.getSelectedProtocolVersion() != ProtocolVersion.TLS13) {
            salt = chooser.getConfig().getDefaultServerPWDSalt();
        }
        if (salt == null) {
            Digest digest = DigestFactory.createSHA256();
            base = new byte[digest.getDigestSize()];
            byte[] usernamePW = (chooser.getClientPWDUsername() + chooser.getPWDPassword()).getBytes(StandardCharsets.ISO_8859_1);
            digest.update(usernamePW, 0, usernamePW.length);
            digest.doFinal(base, 0);
        } else {
            base = StaticTicketCrypto.generateHMAC(MacAlgorithm.HMAC_SHA256, (chooser.getClientPWDUsername() + chooser.getPWDPassword()).getBytes(StandardCharsets.ISO_8859_1), salt);
        }
        boolean found = false;
        int counter = 0;
        int n = (curve.getModulus().bitLength() + 64) / 8;
        byte[] context = chooser.getSelectedProtocolVersion().is13() ? chooser.getClientRandom() : DataConverter.concatenate((byte[][])new byte[][]{chooser.getClientRandom(), chooser.getServerRandom()});
        Point createdPoint = null;
        byte[] savedSeed = null;
        do {
            byte[] seedInput;
            byte[] seed;
            byte[] tmp;
            BigInteger tmpX;
            Point tempPoint;
            if ((tempPoint = curve.createAPointOnCurve(tmpX = new BigInteger(1, tmp = PWDComputations.prf(chooser, seed = StaticTicketCrypto.generateHMAC(randomFunction, seedInput = DataConverter.concatenate((byte[][])new byte[][]{base, DataConverter.intToBytes((int)(++counter), (int)1), DataConverter.bigIntegerToByteArray((BigInteger)curve.getModulus())}), new byte[4]), context, n)).mod(curve.getModulus().subtract(BigInteger.ONE)).add(BigInteger.ONE), false)) != null) {
                createdPoint = tempPoint;
                found = true;
                chooser.getContext().getTlsContext().getBadSecureRandom().nextBytes(base);
            }
            savedSeed = (byte[])seed.clone();
        } while (!found && counter < 1000);
        if (createdPoint == null) {
            LOGGER.warn("Could not find a useful pwd point. Falling back to base point of curve.");
            createdPoint = curve.getBasePoint();
        }
        int lsbSeed = savedSeed[0] & 1;
        int n2 = lsbY = createdPoint.getFieldY().getData().getLowestSetBit() == 0 ? 1 : 0;
        if (lsbSeed == lsbY) {
            createdPoint = curve.inverse(createdPoint);
        }
        return createdPoint;
    }

    protected static MacAlgorithm getMacAlgorithm(CipherSuite suite) {
        if (suite.isSHA256()) {
            return MacAlgorithm.HMAC_SHA256;
        }
        if (suite.isSHA384()) {
            return MacAlgorithm.HMAC_SHA384;
        }
        if (suite.name().endsWith("SHA")) {
            return MacAlgorithm.HMAC_SHA1;
        }
        throw new PreparationException("Unsupported Mac Algorithm for suite " + suite.toString());
    }

    protected static byte[] prf(Chooser chooser, byte[] seed, byte[] context, int outlen) throws CryptoException {
        if (chooser.getSelectedProtocolVersion().is13()) {
            HKDFAlgorithm hkdfAlgorithm = AlgorithmResolver.getHKDFAlgorithm(chooser.getSelectedCipherSuite());
            DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
            MessageDigest hashFunction = null;
            try {
                hashFunction = MessageDigest.getInstance(digestAlgo.getJavaName());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CryptoException("Could not initialize HKDF", (Throwable)ex);
            }
            hashFunction.update(context);
            byte[] hashValue = hashFunction.digest();
            return HKDFunction.expandLabel(hkdfAlgorithm, seed, "TLS-PWD Hunting And Pecking", hashValue, outlen, chooser.getSelectedProtocolVersion());
        }
        PRFAlgorithm prf = AlgorithmResolver.getPRFAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
        if (prf != null) {
            return PseudoRandomFunction.compute(prf, seed, "TLS-PWD Hunting And Pecking", context, outlen);
        }
        LOGGER.warn("Could not select prf for {} and {}", (Object)chooser.getSelectedProtocolVersion(), (Object)chooser.getSelectedCipherSuite());
        return new byte[outlen];
    }

    public static PWDKeyMaterial generateKeyMaterial(CyclicGroup<?> group, Point passwordElement, Chooser chooser) {
        BigInteger mask;
        if (!(group instanceof EllipticCurve)) {
            LOGGER.debug("Can only compute the password element for elliptic curves. Returning Empty PWDKeyMaterial");
            return new PWDKeyMaterial();
        }
        EllipticCurve curve = (EllipticCurve)group;
        PWDKeyMaterial keyMaterial = new PWDKeyMaterial();
        if (chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            mask = new BigInteger(1, chooser.getConfig().getDefaultClientPWDMask()).mod(curve.getBasePointOrder());
            keyMaterial.privateKeyScalar = new BigInteger(1, chooser.getConfig().getDefaultClientPWDPrivate()).mod(curve.getBasePointOrder());
        } else {
            mask = new BigInteger(1, chooser.getConfig().getDefaultServerPWDMask()).mod(curve.getBasePointOrder());
            keyMaterial.privateKeyScalar = new BigInteger(1, chooser.getConfig().getDefaultServerPWDPrivate()).mod(curve.getBasePointOrder());
        }
        keyMaterial.scalar = mask.add(keyMaterial.privateKeyScalar).mod(curve.getBasePointOrder());
        keyMaterial.element = curve.inverse(curve.mult(mask, passwordElement));
        return keyMaterial;
    }

    public Point getPasswordElement() {
        return this.passwordElement;
    }

    public void setPasswordElement(Point passwordElement) {
        this.passwordElement = passwordElement;
    }

    public BigInteger getPrivateKeyScalar() {
        return this.privateKeyScalar;
    }

    public void setPrivateKeyScalar(BigInteger privateKeyScalar) {
        this.privateKeyScalar = privateKeyScalar;
    }

    public static class PWDKeyMaterial {
        public BigInteger privateKeyScalar;
        public BigInteger scalar;
        public Point element;
    }
}

