/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SupplementalDataHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.supplementaldata.SupplementalDataEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.SupplementalDataParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SupplementalDataPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SupplementalDataSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="SupplementalData")
public class SupplementalDataMessage
extends HandshakeMessage {
    @HoldsModifiableVariable
    private List<SupplementalDataEntry> entries;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger supplementalDataLength;
    @ModifiableVariableProperty
    private ModifiableByteArray supplementalDataBytes;

    public SupplementalDataMessage(Config config, LinkedList<SupplementalDataEntry> entries) {
        super(HandshakeMessageType.SUPPLEMENTAL_DATA);
        this.entries = new LinkedList<SupplementalDataEntry>(entries);
    }

    public SupplementalDataMessage() {
        super(HandshakeMessageType.SUPPLEMENTAL_DATA);
        this.entries = new LinkedList<SupplementalDataEntry>();
    }

    public List<SupplementalDataEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SupplementalDataEntry> entries) {
        this.entries = entries;
    }

    public ModifiableInteger getSupplementalDataLength() {
        return this.supplementalDataLength;
    }

    public void setSupplementalDataLength(ModifiableInteger supplementalDataLength) {
        this.supplementalDataLength = supplementalDataLength;
    }

    public void setSupplementalDataLength(int supplementalDataLength) {
        this.supplementalDataLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.supplementalDataLength, (Integer)supplementalDataLength);
    }

    public ModifiableByteArray getSupplementalDataBytes() {
        return this.supplementalDataBytes;
    }

    public void setSupplementalDataBytes(ModifiableByteArray supplementalDataBytes) {
        this.supplementalDataBytes = supplementalDataBytes;
    }

    public void setSupplementalDataBytes(byte[] supplementalDataBytes) {
        this.supplementalDataBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.supplementalDataBytes, (byte[])supplementalDataBytes);
    }

    @Override
    public SupplementalDataHandler getHandler(Context context) {
        return new SupplementalDataHandler(context.getTlsContext());
    }

    @Override
    public SupplementalDataParser getParser(Context context, InputStream stream) {
        return new SupplementalDataParser(stream, context.getTlsContext());
    }

    @Override
    public SupplementalDataPreparator getPreparator(Context context) {
        return new SupplementalDataPreparator(context.getChooser(), this);
    }

    @Override
    public SupplementalDataSerializer getSerializer(Context context) {
        return new SupplementalDataSerializer(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SupplementalDataMessage:");
        sb.append("\n  Supplemental Data Length: ");
        if (this.supplementalDataLength != null && this.supplementalDataLength.getValue() != null) {
            sb.append(this.supplementalDataLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  SupplementalDataEntries:\n");
        if (!this.entries.isEmpty()) {
            for (SupplementalDataEntry entry : this.entries) {
                sb.append("\n   Supplemental Data Type: ").append(entry.getSupplementalDataEntryType().getValue());
                sb.append("\n   Supplemental Data Length: ").append(entry.getSupplementalDataEntryLength().getValue());
                sb.append("\n   Supplemental Data : ").append(DataConverter.bytesToHexString((byte[])((byte[])entry.getSupplementalDataEntry().getValue())));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "SDM";
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.entries);
        hash = 29 * hash + Objects.hashCode(this.supplementalDataLength);
        hash = 29 * hash + Objects.hashCode(this.supplementalDataBytes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupplementalDataMessage other = (SupplementalDataMessage)obj;
        if (!Objects.equals(this.entries, other.entries)) {
            return false;
        }
        if (!Objects.equals(this.supplementalDataLength, other.supplementalDataLength)) {
            return false;
        }
        return Objects.equals(this.supplementalDataBytes, other.supplementalDataBytes);
    }
}

