/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.handler.PskEcDheServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.PskEcDheServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PskEcDheServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PskEcDheServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement(name="PskEcDheServerKeyExchange")
public class PskEcDheServerKeyExchangeMessage
extends ECDHEServerKeyExchangeMessage {
    private ModifiableByteArray identityHint;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger identityHintLength;

    public ModifiableByteArray getIdentityHint() {
        return this.identityHint;
    }

    public void setIdentityHint(ModifiableByteArray identityHint) {
        this.identityHint = identityHint;
    }

    public void setIdentityHint(byte[] identity) {
        this.identityHint = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identityHint, (byte[])identity);
    }

    public ModifiableInteger getIdentityHintLength() {
        return this.identityHintLength;
    }

    public void setIdentityHintLength(ModifiableInteger identityHintLength) {
        this.identityHintLength = identityHintLength;
    }

    public void setIdentityHintLength(int identityHintLength) {
        this.identityHintLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityHintLength, (Integer)identityHintLength);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PskEcDheServerKeyExchangeMessage:");
        sb.append("\n  Curve Type: ");
        if (this.curveType != null && this.curveType.getValue() != null) {
            sb.append((Object)EllipticCurveType.getCurveType((Byte)this.curveType.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Named Group: ");
        if (this.namedGroup != null && this.namedGroup.getValue() != null) {
            sb.append((Object)NamedGroup.getNamedGroup((byte[])this.namedGroup.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Public Key: ");
        if (this.getPublicKey() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getPublicKey().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public PskEcDheServerKeyExchangeHandler getHandler(Context context) {
        return new PskEcDheServerKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public PskEcDheServerKeyExchangeParser getParser(Context context, InputStream stream) {
        return new PskEcDheServerKeyExchangeParser(stream, context.getTlsContext());
    }

    @Override
    public PskEcDheServerKeyExchangePreparator getPreparator(Context context) {
        return new PskEcDheServerKeyExchangePreparator(context.getChooser(), this);
    }

    @Override
    public PskEcDheServerKeyExchangeSerializer getSerializer(Context context) {
        return new PskEcDheServerKeyExchangeSerializer(this, context.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ECDHE_PSK_SERVER_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "PSK_ECDHE_SKE";
    }
}

