/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.PskClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PSKPremasterComputations;
import de.rub.nds.tlsattacker.core.protocol.parser.PskClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PskClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PskClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;

@XmlRootElement(name="PskClientKeyExchange")
public class PskClientKeyExchangeMessage
extends ClientKeyExchangeMessage {
    @HoldsModifiableVariable
    @XmlElement
    protected PSKPremasterComputations computations;
    @ModifiableVariableProperty
    private ModifiableByteArray identity;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger identityLength;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PskClientKeyExchangeMessage:");
        sb.append("\n  PSKIdentity Length: ");
        if (this.identityLength != null && this.identityLength.getValue() != null) {
            sb.append(this.identityLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  PSKIdentity: ");
        if (this.identity != null && this.identity.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.identity.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public PSKPremasterComputations getComputations() {
        return this.computations;
    }

    public ModifiableByteArray getIdentity() {
        return this.identity;
    }

    public void setIdentity(ModifiableByteArray identity) {
        this.identity = identity;
    }

    public void setIdentity(byte[] identity) {
        this.identity = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identity, (byte[])identity);
    }

    public ModifiableInteger getIdentityLength() {
        return this.identityLength;
    }

    public void setIdentityLength(ModifiableInteger identityLength) {
        this.identityLength = identityLength;
    }

    public void setIdentityLength(int identityLength) {
        this.identityLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityLength, (Integer)identityLength);
    }

    @Override
    public PskClientKeyExchangeHandler getHandler(Context context) {
        return new PskClientKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public PskClientKeyExchangeParser getParser(Context context, InputStream stream) {
        return new PskClientKeyExchangeParser(stream, context.getTlsContext());
    }

    @Override
    public PskClientKeyExchangePreparator getPreparator(Context context) {
        return new PskClientKeyExchangePreparator(context.getChooser(), this);
    }

    @Override
    public PskClientKeyExchangeSerializer getSerializer(Context context) {
        return new PskClientKeyExchangeSerializer(this);
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PSK_CLIENT_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public void prepareComputations() {
        if (this.computations == null) {
            this.computations = new PSKPremasterComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }

    @Override
    public String toShortString() {
        return "PSK_CKE";
    }
}

