/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bool.ModifiableBoolean;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HandshakeMessage
extends ProtocolMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlTransient
    protected boolean isIncludeInDigestDefault = true;
    @XmlTransient
    protected boolean isRetranmissionDefault = false;
    @XmlTransient
    protected final HandshakeMessageType handshakeMessageType;
    private ModifiableByte type = null;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger length = null;
    @ModifiableVariableProperty
    private ModifiableBoolean includeInDigest = null;
    @ModifiableVariableProperty
    private ModifiableBoolean retransmission = null;
    private ModifiableByteArray messageContent = null;
    @XmlElementWrapper
    @XmlElementRef
    @HoldsModifiableVariable
    private List<ExtensionMessage> extensions;
    @ModifiableVariableProperty
    private ModifiableByteArray extensionBytes;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger extensionsLength;
    @ModifiableVariableProperty
    private ModifiableInteger messageSequence = null;

    public HandshakeMessage(HandshakeMessageType handshakeMessageType) {
        this.protocolMessageType = ProtocolMessageType.HANDSHAKE;
        this.handshakeMessageType = handshakeMessageType;
    }

    public final List<ExtensionMessage> getExtensions() {
        return this.extensions;
    }

    public final <T extends ExtensionMessage> T getExtension(Class<T> extensionClass) {
        if (this.getExtensions() == null) {
            return null;
        }
        ArrayList<ExtensionMessage> extensionMessages = new ArrayList<ExtensionMessage>(this.getExtensions());
        Optional<ExtensionMessage> extension = extensionMessages.stream().filter(i -> i.getClass().equals(extensionClass)).findFirst();
        if (extension.isPresent()) {
            return (T)((ExtensionMessage)extensionClass.cast(extension.get()));
        }
        return null;
    }

    public final void setExtensions(List<ExtensionMessage> extensions) {
        this.extensions = extensions;
    }

    public List<ExtensionMessage> createConfiguredExtensions(Config tlsConfig) {
        return new LinkedList<ExtensionMessage>();
    }

    public final void addExtension(ExtensionMessage extension) {
        if (this.extensions == null) {
            this.extensions = new LinkedList<ExtensionMessage>();
        }
        if (extension != null) {
            this.extensions.add(extension);
        } else {
            LOGGER.error("Cannot add null Extension");
        }
    }

    public boolean containsExtension(ExtensionType extensionType) {
        if (this.extensions != null) {
            for (ExtensionMessage e : this.extensions) {
                if (e.getExtensionTypeConstant() != extensionType) continue;
                return true;
            }
        }
        return false;
    }

    public void setExtensionBytes(byte[] extensionBytes) {
        this.extensionBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.extensionBytes, (byte[])extensionBytes);
    }

    public void setExtensionBytes(ModifiableByteArray extensionBytes) {
        this.extensionBytes = extensionBytes;
    }

    public ModifiableByteArray getExtensionBytes() {
        return this.extensionBytes;
    }

    public ModifiableInteger getExtensionsLength() {
        return this.extensionsLength;
    }

    public void setExtensionsLength(ModifiableInteger extensionsLength) {
        this.extensionsLength = extensionsLength;
    }

    public void setExtensionsLength(int extensionsLength) {
        this.extensionsLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.extensionsLength, (Integer)extensionsLength);
    }

    public ModifiableByte getType() {
        return this.type;
    }

    public boolean getIncludeInDigest() {
        if (this.includeInDigest == null) {
            return this.isIncludeInDigestDefault;
        }
        if (this.includeInDigest.getValue() == null) {
            this.includeInDigest.setOriginalValue(Boolean.valueOf(this.isIncludeInDigestDefault));
        }
        return (Boolean)this.includeInDigest.getValue();
    }

    public boolean isRetransmission() {
        if (this.retransmission == null) {
            return this.isRetranmissionDefault;
        }
        if (this.retransmission.getValue() == null) {
            this.retransmission.setOriginalValue(Boolean.valueOf(this.isRetranmissionDefault));
        }
        return (Boolean)this.retransmission.getValue();
    }

    public void setType(ModifiableByte type) {
        this.type = type;
    }

    public void setType(Byte type) {
        this.type = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.type, (Byte)type);
    }

    public ModifiableInteger getLength() {
        return this.length;
    }

    public void setLength(ModifiableInteger length) {
        this.length = length;
    }

    public void setLength(int length) {
        this.length = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.length, (Integer)length);
    }

    public HandshakeMessageType getHandshakeMessageType() {
        return this.handshakeMessageType;
    }

    public void setIncludeInDigest(ModifiableBoolean includeInDigest) {
        this.includeInDigest = includeInDigest;
    }

    public void setIncludeInDigest(boolean includeInDigest) {
        this.includeInDigest = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.includeInDigest, (Boolean)includeInDigest);
    }

    public ModifiableBoolean getIncludeInDigestModifiableBoolean() {
        return this.includeInDigest;
    }

    public void setRetransmission(ModifiableBoolean retransmission) {
        this.retransmission = retransmission;
    }

    public void setRetransmission(boolean retransmission) {
        this.retransmission = ModifiableVariableFactory.safelySetValue((ModifiableBoolean)this.retransmission, (Boolean)retransmission);
    }

    public ModifiableBoolean isRetransmissionModifiableBoolean() {
        return this.retransmission;
    }

    public ModifiableInteger getMessageSequence() {
        return this.messageSequence;
    }

    public void setMessageSequence(ModifiableInteger messageSequence) {
        this.messageSequence = messageSequence;
    }

    public void setMessageSequence(int messageSequence) {
        this.messageSequence = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.messageSequence, (Integer)messageSequence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HandshakeMessage:");
        sb.append("\n  Type: ");
        if (this.type != null && this.type.getValue() != null) {
            sb.append(this.type.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Length: ");
        if (this.length != null && this.length.getValue() != null) {
            sb.append("\n  Length: ").append(this.length.getValue());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.handshakeMessageType.getName());
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List holders = super.getAllModifiableVariableHolders();
        if (this.getExtensions() != null) {
            for (ExtensionMessage em : this.getExtensions()) {
                if (em == null) continue;
                holders.addAll(em.getAllModifiableVariableHolders());
            }
        }
        return holders;
    }

    @Override
    public abstract HandshakeMessageParser<? extends HandshakeMessage> getParser(Context var1, InputStream var2);

    @Override
    public abstract HandshakeMessagePreparator<? extends HandshakeMessage> getPreparator(Context var1);

    @Override
    public abstract HandshakeMessageSerializer<? extends HandshakeMessage> getSerializer(Context var1);

    @Override
    public abstract HandshakeMessageHandler<? extends HandshakeMessage> getHandler(Context var1);

    public ModifiableByteArray getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(ModifiableByteArray messageContent) {
        this.messageContent = messageContent;
    }

    public void setMessageContent(byte[] content) {
        this.messageContent = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.messageContent, (byte[])content);
    }
}

