/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.handler.DHEServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.DHEServerComputations;
import de.rub.nds.tlsattacker.core.protocol.parser.DHEServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.DHEServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.DHEServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.util.List;

@XmlRootElement(name="DHEServerKeyExchange")
public class DHEServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @ModifiableVariableProperty
    protected ModifiableByteArray modulus;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    protected ModifiableInteger modulusLength;
    @ModifiableVariableProperty
    protected ModifiableByteArray generator;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    protected ModifiableInteger generatorLength;
    @HoldsModifiableVariable
    protected DHEServerComputations computations;

    public ModifiableByteArray getModulus() {
        return this.modulus;
    }

    public void setModulus(ModifiableByteArray modulus) {
        this.modulus = modulus;
    }

    public void setModulus(byte[] modulus) {
        this.modulus = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.modulus, (byte[])modulus);
    }

    public ModifiableByteArray getGenerator() {
        return this.generator;
    }

    public void setGenerator(ModifiableByteArray generator) {
        this.generator = generator;
    }

    public void setGenerator(byte[] generator) {
        this.generator = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.generator, (byte[])generator);
    }

    public ModifiableInteger getModulusLength() {
        return this.modulusLength;
    }

    public void setModulusLength(ModifiableInteger modulusLength) {
        this.modulusLength = modulusLength;
    }

    public void setModulusLength(int modulusLength) {
        this.modulusLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.modulusLength, (Integer)modulusLength);
    }

    public ModifiableInteger getGeneratorLength() {
        return this.generatorLength;
    }

    public void setGeneratorLength(ModifiableInteger generatorLength) {
        this.generatorLength = generatorLength;
    }

    public void setGeneratorLength(int generatorLength) {
        this.generatorLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.generatorLength, (Integer)generatorLength);
    }

    @Override
    public DHEServerComputations getKeyExchangeComputations() {
        return this.computations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DHEServerKeyExchangeMessage:");
        sb.append("\n  Modulus p: ");
        if (this.modulus != null && this.modulus.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.modulus.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Generator g: ");
        if (this.generator != null && this.generator.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.generator.getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Public Key: ");
        if (this.getPublicKey() != null && this.getPublicKey().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getPublicKey().getValue()), (boolean)false));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature and Hash Algorithm: ");
        if (this.getSignatureAndHashAlgorithm() != null && this.getSignatureAndHashAlgorithm().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSignatureAndHashAlgorithm().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Signature: ");
        if (this.getSignature() != null && this.getSignature().getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.getSignature().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public DHEServerKeyExchangeHandler<? extends DHEServerKeyExchangeMessage> getHandler(Context context) {
        return new DHEServerKeyExchangeHandler(context.getTlsContext());
    }

    @Override
    public DHEServerKeyExchangeParser<? extends DHEServerKeyExchangeMessage> getParser(Context context, InputStream stream) {
        return new DHEServerKeyExchangeParser(stream, context.getTlsContext());
    }

    @Override
    public DHEServerKeyExchangePreparator<? extends DHEServerKeyExchangeMessage> getPreparator(Context context) {
        return new DHEServerKeyExchangePreparator<DHEServerKeyExchangeMessage>(context.getChooser(), this);
    }

    @Override
    public DHEServerKeyExchangeSerializer<? extends DHEServerKeyExchangeMessage> getSerializer(Context context) {
        return new DHEServerKeyExchangeSerializer<DHEServerKeyExchangeMessage>(this, context.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DHE_SERVER_KEY_EXCHANGE");
        if (this.isRetransmission()) {
            sb.append(" (ret.)");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "DH_SKE";
    }

    @Override
    public void prepareKeyExchangeComputations() {
        if (this.getKeyExchangeComputations() == null) {
            this.computations = new DHEServerComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }
}

