/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.handler.ApplicationMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.parser.ApplicationMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.ApplicationMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.ApplicationMessageSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.InputStream;
import java.util.Arrays;

@XmlRootElement(name="Application")
public class ApplicationMessage
extends ProtocolMessage {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] dataConfig = null;
    @ModifiableVariableProperty
    private ModifiableByteArray data;

    public ApplicationMessage(byte[] dataConfig) {
        this.dataConfig = dataConfig;
        this.protocolMessageType = ProtocolMessageType.APPLICATION_DATA;
    }

    public ApplicationMessage() {
        this.protocolMessageType = ProtocolMessageType.APPLICATION_DATA;
    }

    public ModifiableByteArray getData() {
        return this.data;
    }

    public void setData(ModifiableByteArray data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        if (this.data == null) {
            this.data = new ModifiableByteArray();
        }
        this.data.setOriginalValue(data);
    }

    public byte[] getDataConfig() {
        return this.dataConfig;
    }

    public void setDataConfig(byte[] dataConfig) {
        this.dataConfig = dataConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationMessage:");
        sb.append("\n  Data: ");
        if (this.data != null && this.data.getValue() != null) {
            sb.append(DataConverter.bytesToHexString((byte[])((byte[])this.data.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        return "APPLICATION";
    }

    @Override
    public String toShortString() {
        return "APP";
    }

    @Override
    public ApplicationMessageHandler getHandler(Context context) {
        return new ApplicationMessageHandler(context.getTlsContext());
    }

    @Override
    public ApplicationMessageParser getParser(Context context, InputStream stream) {
        return new ApplicationMessageParser(stream);
    }

    @Override
    public ApplicationMessagePreparator getPreparator(Context tlsContext) {
        return new ApplicationMessagePreparator(tlsContext.getChooser(), this);
    }

    @Override
    public ApplicationMessageSerializer getSerializer(Context context) {
        return new ApplicationMessageSerializer(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Arrays.hashCode(this.dataConfig);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationMessage other = (ApplicationMessage)obj;
        return Arrays.equals(this.dataConfig, other.dataConfig);
    }
}

