/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.handler.AlertHandler;
import de.rub.nds.tlsattacker.core.protocol.parser.AlertParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.AlertPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.AlertSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.InputStream;
import java.util.Objects;

@XmlRootElement(name="Alert")
public class AlertMessage
extends ProtocolMessage {
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] config;
    @ModifiableVariableProperty
    private ModifiableByte level;
    @ModifiableVariableProperty
    private ModifiableByte description;

    public AlertMessage() {
        this.protocolMessageType = ProtocolMessageType.ALERT;
    }

    public ModifiableByte getLevel() {
        return this.level;
    }

    public void setLevel(byte level) {
        this.level = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.level, (Byte)level);
    }

    public void setLevel(ModifiableByte level) {
        this.level = level;
    }

    public ModifiableByte getDescription() {
        return this.description;
    }

    public void setDescription(byte description) {
        this.description = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.description, (Byte)description);
    }

    public void setDescription(ModifiableByte description) {
        this.description = description;
    }

    public byte[] getConfig() {
        return this.config;
    }

    public void setConfig(byte[] config) {
        this.config = config;
    }

    public void setConfig(AlertLevel level, AlertDescription description) {
        this.config = new byte[2];
        this.config[0] = level.getValue();
        this.config[1] = description.getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AlertMessage:");
        sb.append("\n  Level: ");
        if (this.level != null) {
            if (AlertLevel.getAlertLevel((Byte)this.level.getValue()) == AlertLevel.UNDEFINED) {
                sb.append(this.level.getValue());
            } else {
                sb.append((Object)AlertLevel.getAlertLevel((Byte)this.level.getValue()));
            }
        } else {
            sb.append("null");
        }
        sb.append("\n  Description: ");
        if (this.description != null) {
            if (AlertDescription.getAlertDescription((Byte)this.description.getValue()) == null) {
                sb.append(this.description.getValue());
            } else {
                sb.append((Object)AlertDescription.getAlertDescription((Byte)this.description.getValue()));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        AlertDescription desc;
        StringBuilder sb = new StringBuilder();
        String levelString = this.level != null && this.level.getValue() != null ? AlertLevel.getAlertLevel((Byte)this.level.getValue()).name() : "null";
        Object descriptionString = this.description != null && this.description.getValue() != null ? ((desc = AlertDescription.getAlertDescription((Byte)this.description.getValue())) != null ? desc.name() : String.valueOf(this.description.getValue())) : (this.config != null && this.config.length == 2 ? ((desc = AlertDescription.getAlertDescription(this.config[1])) != null ? desc.name() : "" + this.config[1]) : "null");
        sb.append("Alert(").append(levelString).append(",").append((String)descriptionString).append(")");
        return sb.toString();
    }

    @Override
    public String toShortString() {
        AlertDescription alertDescription = AlertDescription.getAlertDescription((Byte)this.description.getValue());
        if (alertDescription == null) {
            return "UKNOWN ALERT";
        }
        return alertDescription.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlertMessage)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AlertMessage alert = (AlertMessage)obj;
        if (alert.getLevel() != null && alert.getDescription() != null && this.getLevel() != null && this.getDescription() != null) {
            return Objects.equals(alert.getLevel().getValue(), this.getLevel().getValue()) && Objects.equals(alert.getDescription().getValue(), this.getDescription().getValue());
        }
        if (this.getLevel() == null || alert.getLevel() == null) {
            return Objects.equals(alert.getDescription().getValue(), this.getDescription().getValue());
        }
        return Objects.equals(alert.getLevel().getValue(), this.getLevel().getValue());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.level.getValue());
        hash = 73 * hash + Objects.hashCode(this.description.getValue());
        return hash;
    }

    @Override
    public AlertHandler getHandler(Context context) {
        return new AlertHandler(context.getTlsContext());
    }

    @Override
    public AlertParser getParser(Context context, InputStream stream) {
        return new AlertParser(stream);
    }

    @Override
    public AlertPreparator getPreparator(Context context) {
        return new AlertPreparator(context.getChooser(), this);
    }

    @Override
    public AlertSerializer getSerializer(Context context) {
        return new AlertSerializer(this);
    }
}

