/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfile;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SrtpExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrtpExtensionHandler
extends ExtensionHandler<SrtpExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SrtpExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(SrtpExtensionMessage message) {
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.tlsContext.setClientSupportedSrtpProtectionProfiles(SrtpProtectionProfile.getProfilesAsArrayList((byte[])message.getSrtpProtectionProfiles().getValue()));
            LOGGER.debug("Adjusted the TLS context secure realtime transport protocol protection profiles to {}", (Object)message.getSrtpProtectionProfiles());
            this.tlsContext.setSecureRealTimeProtocolMasterKeyIdentifier((byte[])message.getSrtpMki().getValue());
            LOGGER.debug("Adjusted the TLS context secure realtime transport protocol master key identifier to {}", (Object)message.getSrtpMki());
        } else {
            this.tlsContext.setSelectedSrtpProtectionProfile(SrtpProtectionProfile.getProfileByType((byte[])message.getSrtpProtectionProfiles().getValue()));
            LOGGER.debug("Server selected the SRTP protection profile: {}", (Object)this.tlsContext.getSelectedSrtpProtectionProfile().name());
        }
    }
}

