/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.AdjustmentException;
import de.rub.nds.tlsattacker.core.constants.RecordSizeLimit;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.RecordSizeLimitExtensionMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordSizeLimitExtensionHandler
extends ExtensionHandler<RecordSizeLimitExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RecordSizeLimitExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(RecordSizeLimitExtensionMessage message) {
        byte[] recordSizeLimitBytes = (byte[])message.getRecordSizeLimit().getValue();
        if (recordSizeLimitBytes.length != 2) {
            throw new AdjustmentException("Cannot adjust RecordSizeLimit to a reasonable value");
        }
        Integer recordSizeLimit = DataConverter.bytesToInt((byte[])recordSizeLimitBytes);
        if (recordSizeLimit < RecordSizeLimit.MIN_RECORD_SIZE_LIMIT) {
            LOGGER.warn("RecordSizeLimit is smaller than allowed ({}), resuming anyway", (Object)recordSizeLimit);
        }
        if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer()) {
            LOGGER.debug("Setting OutboundRecordSizeLimit: {}", (Object)recordSizeLimit);
            this.tlsContext.setOutboundRecordSizeLimit(recordSizeLimit);
            this.tlsContext.setPeerReceiveLimit(recordSizeLimit);
        }
    }
}

