/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PSKIdentity;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreSharedKeyExtensionHandler
extends ExtensionHandler<PreSharedKeyExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PreSharedKeyExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(PreSharedKeyExtensionMessage message) {
        LOGGER.debug("Adjusting TLS Context for PSK Key Extension Message");
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
            if (message.getSelectedIdentity() != null) {
                this.adjustPsk(message);
            } else if (this.tlsContext.getChooser().getPskSets().size() > 0) {
                this.tlsContext.setEarlyDataPSKIdentity(this.tlsContext.getChooser().getPskSets().get(0).getPreSharedKeyIdentity());
                this.tlsContext.setEarlyDataCipherSuite(this.tlsContext.getChooser().getPskSets().get(0).getCipherSuite());
            } else {
                LOGGER.warn("Could not adjust EarlyData Identity and Cipher suite");
            }
        }
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER && message.getIdentities() != null && message.getIdentities().size() > 0) {
            this.selectPsk(message);
            if (this.tlsContext.isExtensionNegotiated(ExtensionType.EARLY_DATA)) {
                this.selectEarlyDataPsk(message);
            }
        }
    }

    private void adjustPsk(PreSharedKeyExtensionMessage message) {
        if (message.getSelectedIdentity() != null && message.getSelectedIdentity().getValue() != null && (Integer)message.getSelectedIdentity().getValue() < this.tlsContext.getChooser().getPskSets().size()) {
            LOGGER.debug("Setting PSK as chosen by server");
            this.tlsContext.setPsk(this.tlsContext.getChooser().getPskSets().get((Integer)message.getSelectedIdentity().getValue()).getPreSharedKey());
            this.tlsContext.setSelectedIdentityIndex((Integer)message.getSelectedIdentity().getValue());
        } else {
            LOGGER.warn("The server's chosen PSK identity is unknown - no psk set");
        }
    }

    private void selectPsk(PreSharedKeyExtensionMessage message) {
        int pskIdentityIndex = 0;
        List<PskSet> pskSets = this.tlsContext.getChooser().getPskSets();
        if (message.getIdentities() != null) {
            for (PSKIdentity pskIdentity : message.getIdentities()) {
                for (int x = 0; x < pskSets.size(); ++x) {
                    if (!Arrays.equals(pskSets.get(x).getPreSharedKeyIdentity(), (byte[])pskIdentity.getIdentity().getValue())) continue;
                    LOGGER.debug("Selected PSK identity: {}", (Object)pskSets.get(x).getPreSharedKeyIdentity());
                    this.tlsContext.setPsk(pskSets.get(x).getPreSharedKey());
                    this.tlsContext.setEarlyDataCipherSuite(pskSets.get(x).getCipherSuite());
                    this.tlsContext.setSelectedIdentityIndex(pskIdentityIndex);
                    return;
                }
                ++pskIdentityIndex;
            }
        }
        LOGGER.warn("No matching PSK identity provided by client - no PSK was set");
    }

    private void selectEarlyDataPsk(PreSharedKeyExtensionMessage message) {
        LOGGER.debug("Calculating early traffic secret using transcript: {}", (Object)this.tlsContext.getDigest().getRawBytes());
        List<PskSet> pskSets = this.tlsContext.getChooser().getPskSets();
        for (int x = 0; x < pskSets.size(); ++x) {
            if (!Arrays.equals(pskSets.get(x).getPreSharedKeyIdentity(), (byte[])message.getIdentities().get(0).getIdentity().getValue())) continue;
            this.tlsContext.setEarlyDataPsk(pskSets.get(x).getPreSharedKey());
            this.tlsContext.setEarlyDataCipherSuite(pskSets.get(x).getCipherSuite());
            LOGGER.debug("EarlyData PSK: {}", (Object)pskSets.get(x).getPreSharedKey());
            break;
        }
        if (this.tlsContext.getEarlyDataPsk() == null) {
            LOGGER.warn("Server is missing the EarlyData PSK - decryption will fail");
        }
    }
}

