/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.protocol.exception.AdjustmentException;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.MaxFragmentLengthExtensionMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaxFragmentLengthExtensionHandler
extends ExtensionHandler<MaxFragmentLengthExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public MaxFragmentLengthExtensionHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustTLSExtensionContext(MaxFragmentLengthExtensionMessage message) {
        byte[] maxFragmentLengthBytes = (byte[])message.getMaxFragmentLength().getValue();
        if (maxFragmentLengthBytes.length != 1) {
            throw new AdjustmentException("Cannot adjust MaxFragmentLength to a reasonable value");
        }
        MaxFragmentLength length = MaxFragmentLength.getMaxFragmentLength(maxFragmentLengthBytes[0]);
        if (length == null) {
            LOGGER.warn("Unknown MaxFragmentLength: {}", (Object)maxFragmentLengthBytes);
        } else if (this.tlsContext.getTalkingConnectionEndType() == this.tlsContext.getChooser().getMyConnectionPeer()) {
            LOGGER.debug("Setting MaxFragmentLength: {}", (Object)length.getValue());
            this.tlsContext.setMaxFragmentLength(length);
            this.tlsContext.setPeerReceiveLimit(length.getReceiveLimit());
        }
    }
}

