/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloVerifyRequestHandler
extends HandshakeMessageHandler<HelloVerifyRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloVerifyRequestHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(HelloVerifyRequestMessage message) {
        this.adjustDTLSCookie(message);
    }

    private void adjustDTLSCookie(HelloVerifyRequestMessage message) {
        byte[] dtlsCookie = (byte[])message.getCookie().getValue();
        this.tlsContext.setDtlsCookie(dtlsCookie);
        LOGGER.debug("Set DTLS Cookie in Context to {}", (Object)dtlsCookie);
        this.tlsContext.getDigest().reset();
        LOGGER.debug("Resetting MessageDigest");
    }
}

