/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.EndOfEarlyDataMessage;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndOfEarlyDataHandler
extends HandshakeMessageHandler<EndOfEarlyDataMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public EndOfEarlyDataHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(EndOfEarlyDataMessage message) {
    }

    @Override
    public void adjustContextAfterSerialize(EndOfEarlyDataMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
            this.setClientRecordCipher();
            this.setServertRecordCipher();
        }
    }

    private void setClientRecordCipher() {
        this.tlsContext.setActiveClientKeySetType(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
        KeySet keySet = this.tlsContext.getkeySetHandshake();
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
            this.tlsContext.getRecordLayer().updateDecryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, keySet, false));
        } else {
            this.tlsContext.getRecordLayer().updateEncryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, keySet, true));
        }
    }

    private void setServertRecordCipher() {
        this.tlsContext.setActiveClientKeySetType(Tls13KeySetType.HANDSHAKE_TRAFFIC_SECRETS);
        KeySet keySet = this.tlsContext.getkeySetHandshake();
        if (this.tlsContext.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
            this.tlsContext.getRecordLayer().updateDecryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, keySet, true));
        } else {
            this.tlsContext.getRecordLayer().updateEncryptionCipher(RecordCipherFactory.getRecordCipher(this.tlsContext, keySet, false));
        }
    }
}

