/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.x509attacker.context.X509Context;
import de.rub.nds.x509attacker.x509.X509CertificateChain;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;

public class CertificateMessageHandler
extends HandshakeMessageHandler<CertificateMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateMessageHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    private CertificateType selectTypeInternally() {
        if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            return this.tlsContext.getChooser().getSelectedServerCertificateType();
        }
        return this.tlsContext.getChooser().getSelectedClientCertificateType();
    }

    @Override
    public void adjustContext(CertificateMessage message) {
        switch (this.selectTypeInternally()) {
            case OPEN_PGP: {
                throw new UnsupportedOperationException("We do not support OpenPGP keys");
            }
            case RAW_PUBLIC_KEY: {
                LOGGER.debug("Adjusting context for RAW PUBLIC KEY certificate message");
                try (ASN1InputStream asn1Stream = new ASN1InputStream((byte[])message.getCertificatesListBytes().getValue());){
                    DLSequence dlSeq = (DLSequence)asn1Stream.readObject();
                    DLSequence identifier = (DLSequence)dlSeq.getObjectAt(0);
                    ASN1ObjectIdentifier keyType = (ASN1ObjectIdentifier)identifier.getObjectAt(0);
                    if (keyType.getId().equals("1.2.840.10045.2.1")) {
                        ASN1ObjectIdentifier curveType = (ASN1ObjectIdentifier)identifier.getObjectAt(1);
                        if (!curveType.getId().equals("1.2.840.10045.3.1.7")) {
                            throw new UnsupportedOperationException("We currently do only support secp256r1 public keys. Sorry...");
                        }
                        NamedGroup group = NamedGroup.SECP256R1;
                        DERBitString publicKey = (DERBitString)dlSeq.getObjectAt(1);
                        byte[] pointBytes = publicKey.getBytes();
                        Point publicKeyPoint = PointFormatter.formatFromByteArray((GroupParameters)((NamedEllipticCurveParameters)group.getGroupParameters()), (byte[])pointBytes);
                        this.tlsContext.getTalkingX509Context().setSubjectEcPublicKey(publicKeyPoint);
                        break;
                    }
                    throw new UnsupportedOperationException("We currently do only support EC raw public keys. Sorry...");
                }
                catch (Exception e) {
                    LOGGER.warn("Could read RAW PublicKey. Not adjusting context", (Throwable)e);
                }
                break;
            }
            case X509: {
                LOGGER.debug("Adjusting context for x509 certificate message");
                X509CertificateChain certificateChain = new X509CertificateChain();
                List<CertificateEntry> certificateEntryList = message.getCertificateEntryList();
                for (CertificateEntry entry : certificateEntryList) {
                    X509Certificate x509certificate = entry.getX509certificate();
                    if (x509certificate != null) {
                        certificateChain.addCertificate(x509certificate);
                        continue;
                    }
                    LOGGER.warn("Unparseable certificate entry in chain. Skipping in context");
                }
                if (this.tlsContext.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
                    LOGGER.debug("Setting ClientCertificateChain in Context");
                    this.tlsContext.setClientCertificateChain(certificateChain);
                } else {
                    LOGGER.debug("Setting ServerCertificateChain in Context");
                    this.tlsContext.setServerCertificateChain(certificateChain);
                }
                if (!this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) break;
                this.adjustCertExtensions(message);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported CertificateType!");
            }
        }
    }

    private void adjustCertExtensions(CertificateMessage certificateMessage) {
        for (CertificateEntry pair : certificateMessage.getCertificateEntryList()) {
            if (pair.getExtensionList() == null) continue;
            for (ExtensionMessage extensionMessage : pair.getExtensionList()) {
                Handler handler = extensionMessage.getHandler(this.tlsContext.getContext());
                ((ExtensionHandler)handler).adjustContext(extensionMessage);
            }
        }
    }

    @Override
    public void adjustContextBeforeParse(CertificateMessage message) {
        this.tlsContext.setTalkingX509Context(new X509Context());
    }
}

