/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol;

import de.rub.nds.protocol.exception.ObjectCreationException;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateStatusMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EndOfEarlyDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.KeyUpdateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SupplementalDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownHandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MessageFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static HandshakeMessage generateHandshakeMessage(HandshakeMessageType type, TlsContext tlsContext) {
        switch (type) {
            case CERTIFICATE: {
                return new CertificateMessage();
            }
            case CERTIFICATE_REQUEST: {
                return new CertificateRequestMessage();
            }
            case CERTIFICATE_STATUS: {
                return new CertificateStatusMessage();
            }
            case CERTIFICATE_VERIFY: {
                return new CertificateVerifyMessage();
            }
            case CLIENT_HELLO: {
                return new ClientHelloMessage();
            }
            case CLIENT_KEY_EXCHANGE: {
                return MessageFactory.getClientKeyExchangeMessage(tlsContext);
            }
            case ENCRYPTED_EXTENSIONS: {
                return new EncryptedExtensionsMessage();
            }
            case END_OF_EARLY_DATA: {
                return new EndOfEarlyDataMessage();
            }
            case FINISHED: {
                return new FinishedMessage();
            }
            case HELLO_REQUEST: {
                return new HelloRequestMessage();
            }
            case HELLO_VERIFY_REQUEST: {
                return new HelloVerifyRequestMessage();
            }
            case KEY_UPDATE: {
                return new KeyUpdateMessage();
            }
            case MESSAGE_HASH: {
                LOGGER.warn("Received MessageHash HandshakeMessageType - not implemented yet. Treating as UnknownHandshakeMessage");
                return new UnknownHandshakeMessage();
            }
            case NEW_SESSION_TICKET: {
                return new NewSessionTicketMessage();
            }
            case SERVER_HELLO: {
                return new ServerHelloMessage();
            }
            case SERVER_HELLO_DONE: {
                return new ServerHelloDoneMessage();
            }
            case SERVER_KEY_EXCHANGE: {
                return MessageFactory.getServerKeyExchangeMessage(tlsContext);
            }
            case UNKNOWN: {
                return new UnknownHandshakeMessage();
            }
            case SUPPLEMENTAL_DATA: {
                return new SupplementalDataMessage();
            }
        }
        throw new RuntimeException("Unexpected HandshakeMessage Type " + String.valueOf((Object)type));
    }

    private static ServerKeyExchangeMessage getServerKeyExchangeMessage(TlsContext tlsContext) {
        CipherSuite cs = tlsContext.getChooser().getSelectedCipherSuite();
        KeyExchangeAlgorithm algorithm = cs.getKeyExchangeAlgorithm();
        if (algorithm == null) {
            throw new UnsupportedOperationException("CipherSuite '" + String.valueOf((Object)cs) + "'does not have a KeyExchangeAlgorithm");
        }
        switch (algorithm) {
            case ECDHE_ECDSA: 
            case ECDH_ECDSA: 
            case ECDH_RSA: 
            case ECDHE_RSA: 
            case ECDH_ANON: {
                return new ECDHEServerKeyExchangeMessage();
            }
            case DHE_DSS: 
            case DHE_RSA: 
            case DH_ANON: 
            case DH_DSS: 
            case DH_RSA: {
                return new DHEServerKeyExchangeMessage();
            }
            case RSA: 
            case RSA_EXPORT: {
                return new RSAServerKeyExchangeMessage();
            }
            case PSK: {
                return new PskServerKeyExchangeMessage();
            }
            case DHE_PSK: {
                return new PskDheServerKeyExchangeMessage();
            }
            case ECDHE_PSK: {
                return new PskEcDheServerKeyExchangeMessage();
            }
            case SRP_SHA_DSS: 
            case SRP_SHA_RSA: 
            case SRP_SHA: {
                return new SrpServerKeyExchangeMessage();
            }
            case ECCPWD: {
                return new PWDServerKeyExchangeMessage();
            }
        }
        throw new UnsupportedOperationException("Algorithm " + String.valueOf((Object)algorithm) + " NOT supported yet.");
    }

    private static ClientKeyExchangeMessage getClientKeyExchangeMessage(TlsContext tlsContext) {
        CipherSuite cs = tlsContext.getChooser().getSelectedCipherSuite();
        KeyExchangeAlgorithm algorithm = cs.getKeyExchangeAlgorithm();
        if (algorithm == null) {
            throw new UnsupportedOperationException("CipherSuite '" + String.valueOf((Object)cs) + "'does not have a KeyExchangeAlgorithm");
        }
        switch (algorithm) {
            case RSA: {
                return new RSAClientKeyExchangeMessage();
            }
            case ECDHE_ECDSA: 
            case ECDH_ECDSA: 
            case ECDH_RSA: 
            case ECDHE_RSA: {
                return new ECDHClientKeyExchangeMessage();
            }
            case DHE_DSS: 
            case DHE_RSA: 
            case DH_ANON: 
            case DH_DSS: 
            case DH_RSA: {
                return new DHClientKeyExchangeMessage();
            }
            case DHE_PSK: {
                return new PskDhClientKeyExchangeMessage();
            }
            case ECDHE_PSK: {
                return new PskEcDhClientKeyExchangeMessage();
            }
            case RSA_PSK: {
                return new PskRsaClientKeyExchangeMessage();
            }
            case PSK: {
                return new PskClientKeyExchangeMessage();
            }
            case SRP_SHA_DSS: 
            case SRP_SHA_RSA: 
            case SRP_SHA: {
                return new SrpClientKeyExchangeMessage();
            }
            case VKO_GOST01: 
            case VKO_GOST12: {
                return new GOSTClientKeyExchangeMessage();
            }
            case ECCPWD: {
                return new PWDClientKeyExchangeMessage();
            }
        }
        throw new UnsupportedOperationException("Algorithm " + String.valueOf((Object)algorithm) + " NOT supported yet.");
    }

    public static List<ProtocolMessage> generateProtocolMessages() {
        LinkedList<ProtocolMessage> protocolMessageList = new LinkedList<ProtocolMessage>();
        Set<Class<? extends ProtocolMessage>> classes = MessageFactory.getAllNonAbstractProtocolMessageClasses();
        for (Class<? extends ProtocolMessage> someClass : classes) {
            protocolMessageList.add(MessageFactory.createProtocolMessage(someClass));
        }
        return protocolMessageList;
    }

    public static List<ExtensionMessage> generateExtensionMessages() {
        LinkedList<ExtensionMessage> extensionMessageList = new LinkedList<ExtensionMessage>();
        Set<Class<? extends ExtensionMessage>> classes = MessageFactory.getAllNonAbstractExtensionClasses();
        for (Class<? extends ExtensionMessage> someClass : classes) {
            extensionMessageList.add(MessageFactory.createExtensionMessage(someClass));
        }
        return extensionMessageList;
    }

    private static ExtensionMessage createExtensionMessage(Class<? extends ExtensionMessage> extensionClass) {
        if (Modifier.isAbstract(extensionClass.getModifiers())) {
            throw new IllegalArgumentException("Provided class is abstract");
        }
        try {
            return extensionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ObjectCreationException("Could not create Extension", (Throwable)ex);
        }
    }

    private static ProtocolMessage createProtocolMessage(Class<? extends ProtocolMessage> protocolMessageClass) {
        if (Modifier.isAbstract(protocolMessageClass.getModifiers())) {
            throw new IllegalArgumentException("Provided class is abstract");
        }
        try {
            return protocolMessageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ObjectCreationException("Could not create ProtocolMessage", (Throwable)ex);
        }
    }

    private static Set<Class<? extends ExtensionMessage>> getAllNonAbstractExtensionClasses() {
        Reflections reflections = new Reflections("de.rub.nds.tlsattacker.core.protocol.message.extension", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(ExtensionMessage.class);
        HashSet<Class<? extends ExtensionMessage>> filteredClassSet = new HashSet<Class<? extends ExtensionMessage>>();
        for (Class someClass : classes) {
            if (Modifier.isAbstract(someClass.getModifiers())) continue;
            filteredClassSet.add(someClass);
        }
        return filteredClassSet;
    }

    private static Set<Class<? extends ProtocolMessage>> getAllNonAbstractProtocolMessageClasses() {
        Reflections reflections = new Reflections("de.rub.nds.tlsattacker.core.protocol.message", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(ProtocolMessage.class);
        HashSet<Class<? extends ProtocolMessage>> filteredClassSet = new HashSet<Class<? extends ProtocolMessage>>();
        for (Class someClass : classes) {
            if (Modifier.isAbstract(someClass.getModifiers())) continue;
            filteredClassSet.add(someClass);
        }
        return filteredClassSet;
    }

    public static ProtocolMessage generateRandomProtocolMessage(Random r) {
        List<ProtocolMessage> generateProtocolMessages = MessageFactory.generateProtocolMessages();
        return generateProtocolMessages.get(r.nextInt(generateProtocolMessages.size()));
    }

    public static ExtensionMessage generateRandomExtension(Random r) {
        List<ExtensionMessage> extensionMessages = MessageFactory.generateExtensionMessages();
        return extensionMessages.get(r.nextInt(extensionMessages.size()));
    }

    private MessageFactory() {
    }
}

