/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.protocol.exception.TimeoutException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.hints.RecordLayerHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedInputStream;
import de.rub.nds.tlsattacker.core.layer.stream.HintedLayerInputStream;
import de.rub.nds.tlsattacker.core.protocol.parser.cert.CleanRecordByteSeperator;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.compressor.RecordDecompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Decryptor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.crypto.RecordDecryptor;
import de.rub.nds.tlsattacker.core.record.crypto.RecordEncryptor;
import de.rub.nds.tlsattacker.core.record.parser.RecordParser;
import de.rub.nds.tlsattacker.core.record.preparator.RecordPreparator;
import de.rub.nds.tlsattacker.core.record.serializer.RecordSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordLayer
extends ProtocolLayer<Context, RecordLayerHint, Record> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Context context;
    private final TlsContext tlsContext;
    private final Decryptor decryptor;
    private final Encryptor encryptor;
    private final RecordCompressor compressor;
    private final RecordDecompressor decompressor;
    private int writeEpoch = 0;
    private int readEpoch = 0;

    public RecordLayer(Context context) {
        super(ImplementedLayers.RECORD);
        this.context = context;
        this.tlsContext = context.getTlsContext();
        this.encryptor = new RecordEncryptor(RecordCipherFactory.getNullCipher(this.tlsContext), this.tlsContext);
        this.decryptor = new RecordDecryptor(RecordCipherFactory.getNullCipher(this.tlsContext), this.tlsContext);
        this.compressor = new RecordCompressor(this.tlsContext);
        this.decompressor = new RecordDecompressor(this.tlsContext);
    }

    @Override
    public LayerProcessingResult<Record> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null && configuration.getContainerList() != null) {
            for (Record record : this.getUnprocessedConfiguredContainers()) {
                if (this.skipEmptyRecords(record)) continue;
                ProtocolMessageType contentType = record.getContentMessageType();
                if (contentType == null) {
                    contentType = ProtocolMessageType.UNKNOWN;
                    LOGGER.warn("Sending record without a LayerProcessing hint. Using \"UNKNOWN\" as the type");
                }
                if (this.encryptor.getRecordCipher(this.writeEpoch).getState().getVersion().isDTLS() && record.getEpoch() == null) {
                    record.setEpoch(this.writeEpoch);
                }
                if (record.getCleanProtocolMessageBytes() == null) {
                    record.setCleanProtocolMessageBytes(new byte[0]);
                }
                if (record.shouldPrepare()) {
                    RecordPreparator preparator = record.getRecordPreparator(this.tlsContext, this.encryptor, this.compressor, contentType);
                    preparator.prepare();
                    preparator.afterPrepare();
                }
                RecordSerializer serializer = record.getRecordSerializer();
                byte[] serializedMessage = serializer.serialize();
                record.setCompleteRecordBytes(serializedMessage);
                this.getLowerLayer().sendData(null, (byte[])record.getCompleteRecordBytes().getValue());
                this.addProducedContainer(record);
            }
        }
        return this.getLayerResult();
    }

    private boolean skipEmptyRecords(Record record) {
        return this.context.getConfig().isUseAllProvidedRecords() == false && record.getCompleteRecordBytes() != null && ((byte[])record.getCompleteRecordBytes().getValue()).length == 0;
    }

    @Override
    public LayerProcessingResult<Record> sendData(LayerProcessingHint hint, byte[] data) throws IOException {
        boolean mustStillCoverEmptyMessageFromUpperLayer;
        ProtocolMessageType hintedType = ProtocolMessageType.UNKNOWN;
        if (hint != null && hint instanceof RecordLayerHint) {
            hintedType = ((RecordLayerHint)hint).getType();
        } else {
            LOGGER.warn("Sending record without a LayerProcessing hint. Using \"UNKNOWN\" as the type");
        }
        int maxDataSize = this.context.getConfig().getDefaultMaxRecordData();
        if (this.context.getConfig().isRespectPeerRecordSizeLimitations() && this.context.getChooser().getPeerReceiveLimit() < maxDataSize) {
            maxDataSize = this.context.getChooser().getPeerReceiveLimit();
        }
        CleanRecordByteSeperator separator = new CleanRecordByteSeperator(maxDataSize, new ByteArrayInputStream(data), this.context.getConfig().isCreateRecordsDynamically(), true);
        LinkedList<Record> records = new LinkedList<Record>();
        List givenRecords = this.getUnprocessedConfiguredContainers();
        boolean bl = mustStillCoverEmptyMessageFromUpperLayer = data.length == 0;
        if (this.getLayerConfiguration().getContainerList() != null && givenRecords.size() > 0) {
            if (this.context.getConfig().getPreserveMessageRecordRelation().booleanValue()) {
                records.add((Record)givenRecords.remove(0));
            } else {
                int recordData;
                for (int dataToBeSent = data.length; givenRecords.size() > 0 && (dataToBeSent > 0 || mustStillCoverEmptyMessageFromUpperLayer); dataToBeSent -= recordData) {
                    Record nextRecord = (Record)givenRecords.remove(0);
                    records.add(nextRecord);
                    recordData = nextRecord.getMaxRecordLengthConfig() != null ? nextRecord.getMaxRecordLengthConfig() : maxDataSize;
                }
            }
        }
        separator.parse((List<Record>)records);
        if (separator.getBytesLeft() > 0) {
            LOGGER.warn("Unsent bytes for message {}. Not enough records specified and disabled dynamic record creation in config.", (Object)hintedType);
        }
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (Record record : records) {
            ProtocolMessageType contentType = record.getContentMessageType();
            if (contentType == null) {
                contentType = hintedType;
            }
            if (this.encryptor.getRecordCipher(this.writeEpoch).getState().getVersion().isDTLS()) {
                record.setEpoch(this.writeEpoch);
            }
            if (record.shouldPrepare()) {
                RecordPreparator preparator = record.getRecordPreparator(this.tlsContext, this.encryptor, this.compressor, contentType);
                preparator.prepare();
                preparator.afterPrepare();
            }
            byte[] recordBytes = record.getRecordSerializer().serialize();
            record.setCompleteRecordBytes(recordBytes);
            stream.write((byte[])record.getCompleteRecordBytes().getValue());
            this.addProducedContainer(record);
        }
        this.getLowerLayer().sendData(null, stream.toByteArray());
        return new LayerProcessingResult<Record>(records, this.getLayerType(), true);
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint desiredHint) throws IOException {
        HintedInputStream dataStream = this.getLowerLayer().getDataStream();
        RecordParser parser = new RecordParser(dataStream, this.getDecryptorCipher().getState().getVersion(), this.tlsContext);
        boolean receivedHintRecord = false;
        try {
            while (!receivedHintRecord) {
                Record record = new Record();
                parser.parse(record);
                record.getHandler(this.context).adjustContext(record);
                this.decryptor.decrypt(record);
                this.decompressor.decompress(record);
                this.addProducedContainer(record);
                RecordLayerHint currentHint = this.context.getChooser().getSelectedProtocolVersion().isDTLS() ? new RecordLayerHint(record.getContentMessageType(), (Integer)record.getEpoch().getValue(), ((BigInteger)record.getSequenceNumber().getValue()).intValue()) : new RecordLayerHint(record.getContentMessageType());
                if (desiredHint == null || currentHint.equals(desiredHint)) {
                    receivedHintRecord = true;
                    if (this.currentInputStream == null) {
                        this.currentInputStream = new HintedLayerInputStream(currentHint, this);
                    } else {
                        this.currentInputStream.setHint(currentHint);
                    }
                    this.currentInputStream.extendStream((byte[])record.getCleanProtocolMessageBytes().getValue());
                    continue;
                }
                if (this.nextInputStream == null) {
                    this.nextInputStream = new HintedLayerInputStream(currentHint, this);
                } else {
                    this.nextInputStream.setHint(currentHint);
                }
                this.nextInputStream.extendStream((byte[])record.getCleanProtocolMessageBytes().getValue());
            }
        }
        catch (ParserException e) {
            this.setUnreadBytes(parser.getAlreadyParsed());
            LOGGER.warn("Could not parse Record as a Record. Passing data to upper layer as unknown data", (Throwable)e);
            HintedLayerInputStream tempStream = new HintedLayerInputStream(new RecordLayerHint(ProtocolMessageType.UNKNOWN), this);
            ((HintedInputStream)tempStream).extendStream(dataStream.readAllBytes());
            if (this.currentInputStream == null) {
                this.currentInputStream = tempStream;
            } else {
                this.nextInputStream = tempStream;
            }
        }
        catch (TimeoutException e) {
            LOGGER.warn((Object)e);
            this.setReachedTimeout(true);
        }
        catch (EndOfStreamException ex) {
            this.setUnreadBytes(parser.getAlreadyParsed());
            LOGGER.debug("Reached end of stream, cannot parse more records");
            LOGGER.trace((Object)ex);
            throw ex;
        }
    }

    public RecordCipher getEncryptorCipher() {
        return this.encryptor.getRecordMostRecentCipher();
    }

    public RecordCipher getDecryptorCipher() {
        return this.decryptor.getRecordMostRecentCipher();
    }

    public void updateCompressor() {
        this.compressor.setMethod(this.context.getChooser().getSelectedCompressionMethod());
    }

    public void updateDecompressor() {
        this.decompressor.setMethod(this.context.getChooser().getSelectedCompressionMethod());
    }

    public void updateEncryptionCipher(RecordCipher encryptionCipher) {
        if (encryptionCipher == null) {
            LOGGER.debug("Updating EncryptionCipher with null");
        } else {
            LOGGER.debug("Activating new EncryptionCipher ({})", (Object)encryptionCipher.getClass().getSimpleName());
        }
        this.encryptor.addNewRecordCipher(encryptionCipher);
        ++this.writeEpoch;
    }

    public void updateDecryptionCipher(RecordCipher decryptionCipher) {
        if (decryptionCipher == null) {
            LOGGER.debug("Updating DecryptionCipher with null");
        } else {
            LOGGER.debug("Activating new DecryptionCipher ({})", (Object)decryptionCipher.getClass().getSimpleName());
        }
        this.decryptor.addNewRecordCipher(decryptionCipher);
        ++this.readEpoch;
    }

    public byte[] reencrypt(List<Record> records) {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        for (Record record : records) {
            RecordPreparator preparator = record.getRecordPreparator(this.tlsContext, this.getEncryptor(), this.getCompressor(), record.getContentMessageType());
            preparator.encrypt();
            byte[] recordBytes = record.getRecordSerializer().serialize();
            record.setCompleteRecordBytes(recordBytes);
            stream.write((byte[])record.getCompleteRecordBytes().getValue());
        }
        return stream.toByteArray();
    }

    public void resetEncryptor() {
        this.encryptor.removeAllCiphers();
    }

    public void resetDecryptor() {
        this.decryptor.removeAllCiphers();
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public Decryptor getDecryptor() {
        return this.decryptor;
    }

    public RecordCompressor getCompressor() {
        return this.compressor;
    }

    public RecordDecompressor getDecompressor() {
        return this.decompressor;
    }

    public void increaseWriteEpoch() {
        ++this.writeEpoch;
    }

    public int getWriteEpoch() {
        return this.writeEpoch;
    }

    public void setWriteEpoch(int writeEpoch) {
        this.writeEpoch = writeEpoch;
    }

    public void increaseReadEpoch() {
        ++this.readEpoch;
    }

    public int getReadEpoch() {
        return this.readEpoch;
    }

    public void setReadEpoch(int readEpoch) {
        this.readEpoch = readEpoch;
    }

    @Override
    public LayerProcessingResult<Record> receiveData() {
        try {
            this.receiveMoreDataForHint(null);
        }
        catch (Exception E) {
            LOGGER.error((Object)E);
        }
        return this.getLayerResult();
    }
}

