/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.TimeoutException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.dtls.FragmentManager;
import de.rub.nds.tlsattacker.core.dtls.parser.DtlsHandshakeMessageFragmentParser;
import de.rub.nds.tlsattacker.core.dtls.preparator.DtlsHandshakeMessageFragmentPreparator;
import de.rub.nds.tlsattacker.core.dtls.serializer.DtlsHandshakeMessageFragmentSerializer;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.hints.RecordLayerHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedInputStream;
import de.rub.nds.tlsattacker.core.layer.stream.HintedLayerInputStream;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

public class DtlsFragmentLayer
extends ProtocolLayer<Context, RecordLayerHint, DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Context context;
    private FragmentManager fragmentManager;
    private int readHandshakeMessageSequence = 0;
    private int writeHandshakeMessageSequence = 0;

    public DtlsFragmentLayer(Context context) {
        super(ImplementedLayers.DTLS_FRAGMENT);
        this.context = context;
        this.fragmentManager = new FragmentManager(context.getConfig());
    }

    @Override
    public LayerProcessingResult<DtlsHandshakeMessageFragment> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null && configuration.getContainerList() != null) {
            for (DtlsHandshakeMessageFragment fragment : this.getUnprocessedConfiguredContainers()) {
                if (this.containerAlreadyUsedByHigherLayer(fragment) && this.skipEmptyFragments(fragment)) continue;
                DtlsHandshakeMessageFragmentPreparator preparator = fragment.getPreparator(this.context);
                preparator.prepare();
                DtlsHandshakeMessageFragmentSerializer serializer = fragment.getSerializer(this.context);
                byte[] serializedMessage = serializer.serialize();
                fragment.setCompleteResultingMessage(serializedMessage);
                this.getLowerLayer().sendData(new RecordLayerHint(ProtocolMessageType.HANDSHAKE), serializedMessage);
                this.addProducedContainer(fragment);
            }
        }
        return this.getLayerResult();
    }

    private boolean skipEmptyFragments(DtlsHandshakeMessageFragment fragment) {
        return this.context.getConfig().isUseAllProvidedDtlsFragments() == false && fragment.getFragmentContentConfig() != null && fragment.getFragmentContentConfig().length == 0;
    }

    @Override
    public LayerProcessingResult<DtlsHandshakeMessageFragment> sendData(LayerProcessingHint hint, byte[] data) throws IOException {
        ProtocolMessageType hintedType = hint instanceof RecordLayerHint ? ((RecordLayerHint)hint).getType() : ProtocolMessageType.UNKNOWN;
        if (hintedType == ProtocolMessageType.HANDSHAKE) {
            List<Object> fragments = new LinkedList();
            if (this.getLayerConfiguration().getContainerList() == null || this.getUnprocessedConfiguredContainers().isEmpty()) {
                fragments = this.getEnoughFragments(this.context.getTlsContext(), data.length);
            } else {
                int dataToBeSent;
                DtlsHandshakeMessageFragment dtlsHandshakeMessageFragment;
                List givenFragments = this.getUnprocessedConfiguredContainers();
                for (dataToBeSent = data.length; dataToBeSent > 0 && givenFragments.size() > 0; dataToBeSent -= dtlsHandshakeMessageFragment.getMaxFragmentLengthConfig().intValue()) {
                    dtlsHandshakeMessageFragment = (DtlsHandshakeMessageFragment)givenFragments.remove(0);
                    fragments.add(dtlsHandshakeMessageFragment);
                }
                if (dataToBeSent > 0 && this.context.getConfig().isCreateFragmentsDynamically().booleanValue()) {
                    fragments.addAll(this.getEnoughFragments(this.context.getTlsContext(), dataToBeSent));
                }
            }
            fragments = this.wrapInFragments(HandshakeMessageType.getMessageType(data[0]), Arrays.copyOfRange((byte[])data, (int)4, (int)data.length), fragments);
            SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
            for (DtlsHandshakeMessageFragment dtlsHandshakeMessageFragment : fragments) {
                dtlsHandshakeMessageFragment.getPreparator(this.context).prepare();
                byte[] completeMessage = dtlsHandshakeMessageFragment.getSerializer(this.context).serialize();
                dtlsHandshakeMessageFragment.setCompleteResultingMessage(completeMessage);
                stream.write((byte[])dtlsHandshakeMessageFragment.getCompleteResultingMessage().getValue());
                this.addProducedContainer(dtlsHandshakeMessageFragment);
                if (!this.context.getConfig().isIndividualTransportPacketsForFragments().booleanValue()) continue;
                this.getLowerLayer().sendData(hint, stream.toByteArray());
                stream = new SilentByteArrayOutputStream();
            }
            if (!this.context.getConfig().isIndividualTransportPacketsForFragments().booleanValue()) {
                this.getLowerLayer().sendData(hint, stream.toByteArray());
            }
            return new LayerProcessingResult<Object>(fragments, this.getLayerType(), true);
        }
        this.getLowerLayer().sendData(hint, data);
        return new LayerProcessingResult<DtlsHandshakeMessageFragment>(new LinkedList(), this.getLayerType(), true);
    }

    @Override
    public LayerProcessingResult<DtlsHandshakeMessageFragment> receiveData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint desiredHint) throws IOException {
        try {
            HintedInputStream dataStream = null;
            dataStream = this.getLowerLayer().getDataStream();
            if (dataStream.getHint() == null) {
                LOGGER.warn("The DTLS fragment layer requires a processing hint. E.g. a record type. Parsing as an unknown fragment");
                this.currentInputStream = new HintedLayerInputStream(null, this);
                this.currentInputStream.extendStream(dataStream.readAllBytes());
            } else if (dataStream.getHint() instanceof RecordLayerHint) {
                RecordLayerHint tempHint = (RecordLayerHint)dataStream.getHint();
                if (tempHint.getType() == ProtocolMessageType.HANDSHAKE) {
                    DtlsHandshakeMessageFragment fragment = new DtlsHandshakeMessageFragment();
                    fragment.setEpoch(tempHint.getEpoch());
                    DtlsHandshakeMessageFragmentParser parser = fragment.getParser(this.context, new ByteArrayInputStream(dataStream.readChunk(dataStream.available())));
                    parser.parse(fragment);
                    fragment.setCompleteResultingMessage(fragment.getSerializer(this.context).serialize());
                    this.fragmentManager.addMessageFragment(fragment);
                    List<DtlsHandshakeMessageFragment> uninterpretedMessageFragments = this.fragmentManager.getOrderedCombinedUninterpretedMessageFragments(true, this.context.getConfig().isCanSkipMessageSequenceNumber());
                    if (!uninterpretedMessageFragments.isEmpty()) {
                        DtlsHandshakeMessageFragment uninterpretedMessageFragment = uninterpretedMessageFragments.get(0);
                        this.addProducedContainer(uninterpretedMessageFragment);
                        RecordLayerHint currentHint = new RecordLayerHint(ProtocolMessageType.HANDSHAKE, (Integer)uninterpretedMessageFragment.getMessageSequence().getValue());
                        byte type = (Byte)uninterpretedMessageFragment.getType().getValue();
                        byte[] content = (byte[])uninterpretedMessageFragment.getFragmentContent().getValue();
                        byte[] message = DataConverter.concatenate((byte[][])new byte[][]{{type}, DataConverter.intToBytes((int)content.length, (int)3), content});
                        if (desiredHint == null || currentHint.equals(desiredHint)) {
                            if (this.currentInputStream == null) {
                                this.currentInputStream = new HintedLayerInputStream(currentHint, this);
                            } else {
                                this.currentInputStream.setHint(currentHint);
                            }
                            this.currentInputStream.extendStream(message);
                        } else {
                            if (this.nextInputStream == null) {
                                this.nextInputStream = new HintedLayerInputStream(currentHint, this);
                            } else {
                                this.nextInputStream.setHint(currentHint);
                            }
                            this.nextInputStream.extendStream(message);
                        }
                    } else {
                        this.receiveMoreDataForHint(desiredHint);
                    }
                } else {
                    this.currentInputStream = new HintedLayerInputStream(tempHint, this);
                    this.currentInputStream.extendStream(dataStream.readChunk(dataStream.available()));
                }
            }
        }
        catch (TimeoutException ex) {
            LOGGER.debug("Received a timeout");
            LOGGER.trace((Object)ex);
            throw ex;
        }
        catch (EndOfStreamException ex) {
            LOGGER.debug("Reached end of stream, cannot parse more dtls fragments");
            LOGGER.trace((Object)ex);
            throw ex;
        }
    }

    private List<DtlsHandshakeMessageFragment> getEnoughFragments(TlsContext context, int length) {
        DtlsHandshakeMessageFragment fragment;
        LinkedList<DtlsHandshakeMessageFragment> toFillList = new LinkedList<DtlsHandshakeMessageFragment>();
        for (int fragmentLength = 0; fragmentLength < length; fragmentLength += fragment.getMaxFragmentLengthConfig().intValue()) {
            fragment = new DtlsHandshakeMessageFragment(context.getConfig());
            toFillList.add(fragment);
        }
        return toFillList;
    }

    private List<DtlsHandshakeMessageFragment> wrapInFragments(HandshakeMessageType type, byte[] handshakeBytes, List<DtlsHandshakeMessageFragment> fragments) {
        int currentOffset = 0;
        for (DtlsHandshakeMessageFragment fragment : fragments) {
            Integer maxFragmentLength = fragment.getMaxFragmentLengthConfig();
            if (maxFragmentLength == null) {
                maxFragmentLength = this.context.getConfig().getDtlsMaximumFragmentLength();
            }
            byte[] fragmentBytes = Arrays.copyOfRange((byte[])handshakeBytes, (int)currentOffset, (int)Math.min(currentOffset + maxFragmentLength, handshakeBytes.length));
            fragment.setHandshakeMessageTypeConfig(type);
            fragment.setFragmentContentConfig(fragmentBytes);
            fragment.setMessageSequenceConfig(this.writeHandshakeMessageSequence);
            fragment.setOffsetConfig(currentOffset);
            fragment.setHandshakeMessageLengthConfig(handshakeBytes.length);
            currentOffset += fragmentBytes.length;
        }
        if (currentOffset != handshakeBytes.length) {
            LOGGER.warn("Unsent bytes for message {}. Not enough dtls fragments specified and disabled dynamic fragment creation in config.", (Object)type);
        }
        this.increaseWriteHandshakeMessageSequence();
        return fragments;
    }

    public DtlsHandshakeMessageFragment wrapInSingleFragment(Context context, HandshakeMessage message, boolean goingToBeSent) {
        DtlsHandshakeMessageFragment fragment = new DtlsHandshakeMessageFragment();
        fragment.setHandshakeMessageTypeConfig(message.getHandshakeMessageType());
        byte[] messageContent = ((HandshakeMessageSerializer)message.getSerializer(context)).serializeHandshakeMessageContent();
        fragment.setFragmentContentConfig(messageContent);
        if (message.getMessageSequence() == null) {
            int messageSequence = goingToBeSent ? this.writeHandshakeMessageSequence : this.readHandshakeMessageSequence;
            fragment.setMessageSequenceConfig(messageSequence);
        } else {
            fragment.setMessageSequenceConfig((Integer)message.getMessageSequence().getValue());
        }
        fragment.setOffsetConfig(0);
        fragment.setHandshakeMessageLengthConfig(messageContent.length);
        fragment.getPreparator(context).prepare();
        byte[] completeMessage = fragment.getSerializer(context).serialize();
        fragment.setCompleteResultingMessage(completeMessage);
        return fragment;
    }

    public void resetFragmentManager(Config config) {
        this.fragmentManager = new FragmentManager(config);
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public int getReadHandshakeMessageSequence() {
        return this.readHandshakeMessageSequence;
    }

    public void setReadHandshakeMessageSequence(int readHandshakeMessageSequence) {
        this.readHandshakeMessageSequence = readHandshakeMessageSequence;
    }

    public void increaseReadHandshakeMessageSequence() {
        ++this.readHandshakeMessageSequence;
    }

    public int getWriteHandshakeMessageSequence() {
        return this.writeHandshakeMessageSequence;
    }

    public void setWriteHandshakeMessageSequence(int writeHandshakeMessageSequence) {
        this.writeHandshakeMessageSequence = writeHandshakeMessageSequence;
    }

    public void increaseWriteHandshakeMessageSequence() {
        ++this.writeHandshakeMessageSequence;
    }
}

