/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedInputStream;
import de.rub.nds.tlsattacker.core.state.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProtocolLayer<ContextType extends Context, Hint extends LayerProcessingHint, Container extends DataContainer> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ProtocolLayer<ContextType, Hint, Container> higherLayer = null;
    private ProtocolLayer<ContextType, Hint, Container> lowerLayer = null;
    private LayerConfiguration<Container> layerConfiguration;
    private List<Container> producedDataContainers = new LinkedList<Container>();
    private boolean reachedTimeout = false;
    protected HintedInputStream currentInputStream = null;
    protected HintedInputStream nextInputStream = null;
    private LayerType layerType;
    private byte[] unreadBytes;

    protected ProtocolLayer(LayerType layerType) {
        this.layerType = layerType;
        this.unreadBytes = new byte[0];
    }

    public ProtocolLayer<ContextType, Hint, Container> getHigherLayer() {
        return this.higherLayer;
    }

    public ProtocolLayer<ContextType, Hint, Container> getLowerLayer() {
        return this.lowerLayer;
    }

    public void setHigherLayer(ProtocolLayer<ContextType, Hint, Container> higherLayer) {
        this.higherLayer = higherLayer;
    }

    public void setLowerLayer(ProtocolLayer<ContextType, Hint, Container> lowerLayer) {
        this.lowerLayer = lowerLayer;
    }

    public abstract LayerProcessingResult<Container> sendConfiguration() throws IOException;

    public abstract LayerProcessingResult<Container> sendData(LayerProcessingHint var1, byte[] var2) throws IOException;

    public LayerConfiguration<Container> getLayerConfiguration() {
        return this.layerConfiguration;
    }

    public void setLayerConfiguration(LayerConfiguration<?> layerConfiguration) {
        this.layerConfiguration = layerConfiguration;
    }

    public LayerProcessingResult<Container> getLayerResult() {
        boolean isExecutedAsPlanned = this.executedAsPlanned();
        return new LayerProcessingResult<Container>(this.producedDataContainers, this.getLayerType(), isExecutedAsPlanned, this.getUnreadBytes());
    }

    public boolean executedAsPlanned() {
        boolean isExecutedAsPlanned = true;
        if (this.getLayerConfiguration() != null) {
            isExecutedAsPlanned = this.getLayerConfiguration().executedAsPlanned(this.producedDataContainers);
        }
        return isExecutedAsPlanned;
    }

    public void removeDrainedInputStream() {
        try {
            if (this.currentInputStream != null && this.currentInputStream.available() > 0) {
                throw new RuntimeException("Trying to drain a non-empty inputStream");
            }
            this.currentInputStream = null;
        }
        catch (IOException ex) {
            LOGGER.error("Could not evaluate Stream availability. Removing Stream anyways", (Throwable)ex);
            this.currentInputStream = null;
        }
    }

    public void clear() {
        this.producedDataContainers = new LinkedList<Container>();
        this.layerConfiguration = null;
        this.currentInputStream = null;
        this.nextInputStream = null;
        this.reachedTimeout = false;
    }

    protected void addProducedContainer(Container container) {
        this.producedDataContainers.add(container);
    }

    protected boolean containerAlreadyUsedByHigherLayer(Container container) {
        if (this.producedDataContainers == null) {
            return false;
        }
        return this.producedDataContainers.stream().anyMatch(listedContainer -> listedContainer == container);
    }

    public abstract LayerProcessingResult<Container> receiveData();

    public abstract void receiveMoreDataForHint(LayerProcessingHint var1) throws IOException;

    public HintedInputStream getDataStream() throws IOException {
        if (this.currentInputStream == null) {
            this.receiveMoreDataForHint(null);
            if (this.currentInputStream == null) {
                throw new EndOfStreamException("Could not receive data stream from lower layer, nothing more to receive");
            }
        }
        if (this.currentInputStream.available() > 0) {
            return this.currentInputStream;
        }
        if (this.nextInputStream != null) {
            this.currentInputStream = this.nextInputStream;
            return this.currentInputStream;
        }
        LOGGER.debug("Trying to get datastream while no data is available");
        this.receiveMoreDataForHint(null);
        return this.currentInputStream;
    }

    public boolean isDataBuffered() {
        LOGGER.debug("Checking if data is buffered: {}", (Object)this.getLayerType());
        try {
            if (this.currentInputStream != null && this.currentInputStream.available() > 0 || this.nextInputStream != null && this.nextInputStream.available() > 0) {
                LOGGER.debug("Data buffered in current stream");
                return true;
            }
            if (this.getLowerLayer() != null) {
                LOGGER.debug("Checking if lower layer has data buffered");
                return this.getLowerLayer().isDataBuffered();
            }
            LOGGER.debug("No data is buffered in this layer or lower layers");
            return false;
        }
        catch (IOException e) {
            LOGGER.error("No more data can be read from the inputStreams", (Throwable)e);
            return false;
        }
    }

    public boolean shouldContinueProcessing() {
        LOGGER.debug("Deciding if we should continue...: {} type: {}", this.layerConfiguration, (Object)this.layerType);
        if (this.layerConfiguration != null) {
            return this.layerConfiguration.shouldContinueProcessing(this.getLayerResult().getUsedContainers(), this.reachedTimeout, this.isDataBuffered());
        }
        LOGGER.debug("Checking if data is buffered since no layer configuration exists");
        return this.isDataBuffered();
    }

    public LayerType getLayerType() {
        return this.layerType;
    }

    protected void readDataContainer(Container container, Context context) {
        HintedInputStream inputStream;
        try {
            inputStream = this.getLowerLayer().getDataStream();
        }
        catch (IOException e) {
            LOGGER.warn("The lower layer did not produce a data stream", (Throwable)e);
            return;
        }
        this.readDataContainer(container, context, inputStream);
    }

    protected void readDataContainer(Container container, Context context, InputStream inputStream) {
        Parser<? extends DataContainer> parser = container.getParser(context, inputStream);
        try {
            parser.parse((DataContainer)container);
            if (container.shouldPrepare()) {
                Preparator<? extends DataContainer> preparator = container.getPreparator(context);
                preparator.prepareAfterParse();
            }
            Handler<? extends DataContainer> handler = container.getHandler(context);
            handler.adjustContext((DataContainer)container);
            this.addProducedContainer(container);
        }
        catch (RuntimeException ex) {
            this.setUnreadBytes(parser.getAlreadyParsed());
        }
    }

    public byte[] getUnreadBytes() {
        return this.unreadBytes;
    }

    public void setUnreadBytes(byte[] unreadBytes) {
        this.unreadBytes = unreadBytes;
    }

    public boolean prepareDataContainer(DataContainer dataContainer, Context context) {
        if (dataContainer.shouldPrepare()) {
            Preparator<? extends DataContainer> preparator = dataContainer.getPreparator(context);
            try {
                preparator.prepare();
                preparator.afterPrepare();
            }
            catch (PreparationException ex) {
                LOGGER.error("Could not prepare message {}. Therefore, we skip it.", (Object)dataContainer, (Object)ex);
                return false;
            }
        }
        return true;
    }

    public List<Container> getUnprocessedConfiguredContainers() {
        if (this.getLayerConfiguration() == null || this.getLayerConfiguration().getContainerList() == null) {
            return new LinkedList();
        }
        if (this.producedDataContainers == null) {
            return new LinkedList<Container>(this.getLayerConfiguration().getContainerList());
        }
        return this.getLayerConfiguration().getContainerList().stream().filter(Predicate.not(this.producedDataContainers::contains)).collect(Collectors.toList());
    }

    public void setReachedTimeout(boolean reachedTimeout) {
        this.reachedTimeout = reachedTimeout;
    }

    public boolean hasReachedTimeout() {
        return this.reachedTimeout;
    }
}

