/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="LayerStackProcessingResult")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={ImplementedLayers.class})
public class LayerStackProcessingResult {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<LayerProcessingResult<?>> layerProcessingResultList;
    private boolean hasUnreadBytes;
    @XmlAnyElement(lax=true)
    @XmlElementWrapper
    private final List<LayerType> layersWithUnreadBytes = new LinkedList<LayerType>();

    private LayerStackProcessingResult() {
        this.layerProcessingResultList = null;
    }

    public LayerStackProcessingResult(List<LayerProcessingResult<?>> layerProcessingResultList) {
        this.layerProcessingResultList = layerProcessingResultList;
        for (LayerProcessingResult<?> layerProcessingResult : layerProcessingResultList) {
            if (layerProcessingResult.getUnreadBytes().length == 0) continue;
            this.layersWithUnreadBytes.add(layerProcessingResult.getLayerType());
            this.hasUnreadBytes = true;
        }
    }

    public List<LayerProcessingResult<?>> getLayerProcessingResultList() {
        return this.layerProcessingResultList;
    }

    public LayerProcessingResult<?> getResultForLayer(LayerType layerType) {
        if (this.layerProcessingResultList != null) {
            for (LayerProcessingResult<?> layerResult : this.layerProcessingResultList) {
                if (!layerResult.getLayerType().equals(layerType)) continue;
                return layerResult;
            }
        }
        return null;
    }

    public boolean hasUnreadBytes() {
        return this.hasUnreadBytes;
    }

    public List<LayerType> getLayersWithUnreadBytes() {
        return this.layersWithUnreadBytes;
    }

    public boolean executedAsPlanned() {
        for (LayerProcessingResult<?> result : this.layerProcessingResultList) {
            if (result.isExecutedAsPlanned()) continue;
            LOGGER.warn("{} failed: Layer {}, did not execute as planned", (Object)this.getClass().getSimpleName(), (Object)result.getLayerType());
            return false;
        }
        return true;
    }
}

