/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.LayerStack;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.layer.impl.DtlsFragmentLayer;
import de.rub.nds.tlsattacker.core.layer.impl.HttpLayer;
import de.rub.nds.tlsattacker.core.layer.impl.MessageLayer;
import de.rub.nds.tlsattacker.core.layer.impl.QuicFrameLayer;
import de.rub.nds.tlsattacker.core.layer.impl.QuicPacketLayer;
import de.rub.nds.tlsattacker.core.layer.impl.RecordLayer;
import de.rub.nds.tlsattacker.core.layer.impl.SSL2Layer;
import de.rub.nds.tlsattacker.core.layer.impl.TcpLayer;
import de.rub.nds.tlsattacker.core.layer.impl.UdpLayer;
import de.rub.nds.tlsattacker.core.state.Context;

public class LayerStackFactory {
    public static LayerStack createLayerStack(StackConfiguration type, Context context) {
        switch (type) {
            case OPEN_VPN: 
            case STARTTLS: {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            case DTLS: {
                return new LayerStack(context, new MessageLayer(context), new DtlsFragmentLayer(context), new RecordLayer(context), new UdpLayer(context));
            }
            case QUIC: {
                return new LayerStack(context, new MessageLayer(context), new QuicFrameLayer(context), new QuicPacketLayer(context), new UdpLayer(context));
            }
            case TLS: {
                LayerStack layerStack = new LayerStack(context, new MessageLayer(context), new RecordLayer(context), new TcpLayer(context));
                context.setLayerStack(layerStack);
                return layerStack;
            }
            case HTTPS: {
                LayerStack layerStack = new LayerStack(context, new HttpLayer(context), new MessageLayer(context), new RecordLayer(context), new TcpLayer(context));
                return layerStack;
            }
            case SSL2: {
                LayerStack layerStack = new LayerStack(context, new SSL2Layer(context), new TcpLayer(context));
                return layerStack;
            }
        }
        throw new RuntimeException("Unknown LayerStackType: " + type.name());
    }
}

