/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.DataContainerFilter;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Level;

public abstract class LayerConfiguration<Container extends DataContainer> {
    private List<DataContainerFilter> containerFilterList;
    private final List<Container> containerList;
    private final LayerType layerType;

    public LayerConfiguration(LayerType layerType, List<Container> containerList) {
        this.containerList = containerList;
        this.layerType = layerType;
    }

    @SafeVarargs
    public LayerConfiguration(LayerType layerType, Container ... containers) {
        this.containerList = Arrays.asList(containers);
        this.layerType = layerType;
    }

    public List<Container> getContainerList() {
        return this.containerList;
    }

    public abstract boolean executedAsPlanned(List<Container> var1);

    public abstract boolean shouldContinueProcessing(List<Container> var1, boolean var2, boolean var3);

    public LayerType getLayerType() {
        return this.layerType;
    }

    public abstract String toCompactString();

    public List<DataContainerFilter> getContainerFilterList() {
        return this.containerFilterList;
    }

    public void setContainerFilterList(List<DataContainerFilter> containerFilterList) {
        this.containerFilterList = containerFilterList;
    }

    public abstract boolean shouldBeLogged(Level var1);
}

