/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FragmentStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private HashMap<Integer, Byte> fragmentByteMap = new HashMap();
    private int intendedSize;

    public FragmentStream(int intendedSize) {
        this.intendedSize = intendedSize;
    }

    public boolean canInsertByteArray(byte[] bytesToAdd, int offset) {
        for (int i = 0; i < bytesToAdd.length; ++i) {
            if (!this.fragmentByteMap.containsKey(offset + i) || this.fragmentByteMap.get(offset + i) == bytesToAdd[i]) continue;
            return false;
        }
        return true;
    }

    public void insertByteArray(byte[] bytesToAdd, int offset) {
        for (int i = 0; i < bytesToAdd.length; ++i) {
            if (this.fragmentByteMap.containsKey(offset + i)) {
                this.fragmentByteMap.remove(offset + i);
            }
            this.fragmentByteMap.put(offset + i, bytesToAdd[i]);
        }
    }

    public boolean isComplete(int tillIndex) {
        if (tillIndex < 0) {
            throw new IllegalArgumentException("Cannot check stream for completeness with negative index: " + tillIndex);
        }
        for (int i = 0; i < tillIndex; ++i) {
            if (this.fragmentByteMap.containsKey(i)) continue;
            return false;
        }
        return true;
    }

    public byte[] getCompleteFilledStream(byte fillingByte) {
        try (SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();){
            int fillingCounter = 0;
            for (int i = 0; i < this.intendedSize; ++i) {
                Byte b = this.fragmentByteMap.get(i);
                if (b == null) {
                    b = fillingByte;
                    ++fillingCounter;
                }
                stream.write((int)b.byteValue());
            }
            if (fillingCounter > 0) {
                LOGGER.warn("Had to fill {} missing bytes in HandshakeMessageFragments. This will _likely_ result in invalid messages", (Object)fillingCounter);
            }
            for (Integer i : this.fragmentByteMap.keySet()) {
                if (i <= this.intendedSize) continue;
                LOGGER.warn("Found fragment greater than intended message size(intended size: {} but found byte for: {}). Ignoring", (Object)this.intendedSize, (Object)i);
            }
            Object object = stream.toByteArray();
            return object;
        }
    }

    public byte[] getCompleteTruncatedStream() {
        try (SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();){
            int skipCounter = 0;
            for (int i = 0; i < this.intendedSize; ++i) {
                Byte b = this.fragmentByteMap.get(i);
                if (b == null) {
                    ++skipCounter;
                    continue;
                }
                stream.write((int)b.byteValue());
            }
            if (skipCounter > 0) {
                LOGGER.warn("Did not receive all bytes. Truncated {} missing bytes.", (Object)skipCounter);
            }
            for (Integer i : this.fragmentByteMap.keySet()) {
                if (i <= this.intendedSize) continue;
                LOGGER.warn("Found fragment greater than intended message size(intended size: {} but found byte for: {}). Ignoring", (Object)this.intendedSize, (Object)i);
            }
            Object object = stream.toByteArray();
            return object;
        }
    }
}

