/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.hpke;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.cipher.DecryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeContext;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;

public class HpkeReceiverContext
extends HpkeContext {
    public HpkeReceiverContext(byte[] aeadKey, byte[] baseNonce, int sequenceNumber, byte[] exporterSecret, HpkeAeadFunction hpkeAeadFunction) {
        super(aeadKey, baseNonce, sequenceNumber, exporterSecret, hpkeAeadFunction);
    }

    public byte[] open(byte[] additionalAuthenticatedData, byte[] ciphertext, byte[] nonce) throws CryptoException {
        KeySet keySet = new KeySet();
        keySet.setClientWriteKey(this.aeadKey);
        DecryptionCipher decryptionCipher = CipherWrapper.getDecryptionCipher(this.hpkeAeadFunction.getCipherSuite(), ConnectionEndType.SERVER, keySet);
        byte[] plaintext = decryptionCipher.decrypt(nonce, this.hpkeAeadFunction.getTagLength() * 8, additionalAuthenticatedData, ciphertext);
        this.incrementSequenceNumber();
        return plaintext;
    }

    public byte[] open(byte[] additionalAuthenticatedData, byte[] plaintext) throws CryptoException {
        return this.open(additionalAuthenticatedData, plaintext, this.computeNonce());
    }
}

