/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersionComparator;
import de.rub.nds.tlsattacker.core.exceptions.UnknownProtocolVersionException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public enum ProtocolVersion {
    SSL2(new byte[]{0, 2}),
    SSL3(new byte[]{3, 0}),
    TLS10(new byte[]{3, 1}),
    TLS11(new byte[]{3, 2}),
    TLS12(new byte[]{3, 3}),
    TLS13(new byte[]{3, 4}),
    TLS13_DRAFT14(new byte[]{127, 14}),
    TLS13_DRAFT15(new byte[]{127, 15}),
    TLS13_DRAFT16(new byte[]{127, 16}),
    TLS13_DRAFT17(new byte[]{127, 17}),
    TLS13_DRAFT18(new byte[]{127, 18}),
    TLS13_DRAFT19(new byte[]{127, 19}),
    TLS13_DRAFT20(new byte[]{127, 20}),
    TLS13_DRAFT21(new byte[]{127, 21}),
    TLS13_DRAFT22(new byte[]{127, 22}),
    TLS13_DRAFT23(new byte[]{127, 23}),
    TLS13_DRAFT24(new byte[]{127, 24}),
    TLS13_DRAFT25(new byte[]{127, 25}),
    TLS13_DRAFT26(new byte[]{127, 26}),
    TLS13_DRAFT27(new byte[]{127, 27}),
    TLS13_DRAFT28(new byte[]{127, 28}),
    DTLS10_DRAFT(new byte[]{1, 0}),
    DTLS10(new byte[]{-2, -1}),
    DTLS12(new byte[]{-2, -3}),
    DTLS13(new byte[]{-2, -4}),
    GREASE_00(new byte[]{10, 10}),
    GREASE_01(new byte[]{26, 26}),
    GREASE_02(new byte[]{42, 42}),
    GREASE_03(new byte[]{58, 58}),
    GREASE_04(new byte[]{74, 74}),
    GREASE_05(new byte[]{90, 90}),
    GREASE_06(new byte[]{106, 106}),
    GREASE_07(new byte[]{122, 122}),
    GREASE_08(new byte[]{-118, -118}),
    GREASE_09(new byte[]{-102, -102}),
    GREASE_10(new byte[]{-86, -86}),
    GREASE_11(new byte[]{-70, -70}),
    GREASE_12(new byte[]{-54, -54}),
    GREASE_13(new byte[]{-38, -38}),
    GREASE_14(new byte[]{-22, -22}),
    GREASE_15(new byte[]{-6, -6});

    private byte[] value;
    private static final Map<Integer, ProtocolVersion> MAP;

    private ProtocolVersion(byte[] value) {
        this.value = value;
    }

    private static Integer valueToInt(byte[] value) {
        if (value.length == 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        return null;
    }

    public boolean isDTLS() {
        return this == DTLS10 || this == DTLS12 || this == DTLS10_DRAFT || this == DTLS13;
    }

    public static ProtocolVersion getProtocolVersion(byte[] value) {
        Integer i = ProtocolVersion.valueToInt(value);
        if (i == null) {
            return null;
        }
        return MAP.get(i);
    }

    public static void sort(List<ProtocolVersion> versions) {
        ProtocolVersion.sort(versions, true);
    }

    public static void sort(List<ProtocolVersion> versions, boolean ascending) {
        Comparator<ProtocolVersion> comparator = new ProtocolVersionComparator();
        if (!ascending) {
            comparator = comparator.reversed();
        }
        versions.sort(comparator);
    }

    public static List<ProtocolVersion> getProtocolVersions(byte[] values) {
        LinkedList<ProtocolVersion> versions = new LinkedList<ProtocolVersion>();
        if (values.length % 2 != 0) {
            throw new UnknownProtocolVersionException("Last ProtocolVersion are unknown!");
        }
        for (int pointer = 0; pointer < values.length; pointer += 2) {
            byte[] version = new byte[]{values[pointer], values[pointer + 1]};
            ProtocolVersion tempVersion = ProtocolVersion.getProtocolVersion(version);
            if (tempVersion == null) continue;
            versions.add(tempVersion);
        }
        return versions;
    }

    public static ProtocolVersion getRandom(Random random) {
        ProtocolVersion c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (ProtocolVersion)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte getMajor() {
        return this.value[0];
    }

    public byte getMinor() {
        return this.value[1];
    }

    public static ProtocolVersion fromString(String protocolVersion) {
        protocolVersion = protocolVersion.replaceFirst("v", "");
        protocolVersion = protocolVersion.replaceFirst("\\.", "");
        for (ProtocolVersion pv : ProtocolVersion.values()) {
            if (!protocolVersion.equalsIgnoreCase(pv.toString())) continue;
            return pv;
        }
        throw new IllegalArgumentException("Value " + protocolVersion + " cannot be converted to a protocol version. Available values are: " + Arrays.toString((Object[])ProtocolVersion.values()));
    }

    public static ProtocolVersion getHighestProtocolVersion(List<ProtocolVersion> list) {
        ProtocolVersion highestProtocolVersion = null;
        for (ProtocolVersion pv : list) {
            if (highestProtocolVersion == null) {
                highestProtocolVersion = pv;
                continue;
            }
            if (highestProtocolVersion.compare(pv) != -1) continue;
            highestProtocolVersion = pv;
        }
        return highestProtocolVersion;
    }

    public boolean isTLS13() {
        return this == TLS13 || this.getMajor() == 127;
    }

    public boolean isDTLS13() {
        return this == DTLS13;
    }

    public boolean is13() {
        return this.isTLS13() || this.isDTLS13();
    }

    public boolean isSSL() {
        return this == SSL2 || this == SSL3;
    }

    public boolean isGrease() {
        return this.name().startsWith("GREASE");
    }

    public boolean usesExplicitIv() {
        return this == TLS11 || this == TLS12 || this == DTLS10 || this == DTLS12 || this == DTLS10_DRAFT;
    }

    public int compare(ProtocolVersion otherProtocolVersion) {
        if (otherProtocolVersion == this || otherProtocolVersion.isGrease() && this.isGrease()) {
            return 0;
        }
        if (this.isGrease()) {
            return -1;
        }
        if (otherProtocolVersion.isGrease()) {
            return 1;
        }
        if (this.isDTLS()) {
            return ProtocolVersion.compareDtls(this, otherProtocolVersion);
        }
        return ProtocolVersion.compareSslOrTls(this, otherProtocolVersion);
    }

    private static int compareSslOrTls(ProtocolVersion protocolVersion1, ProtocolVersion protocolVersion2) {
        if (protocolVersion1.isDTLS() || protocolVersion2.isDTLS() || protocolVersion1.isGrease() || protocolVersion2.isGrease()) {
            throw new IllegalArgumentException("Can not compare " + protocolVersion1.toHumanReadable() + " and " + protocolVersion2.toHumanReadable() + " as SSL/TLS versions");
        }
        if (protocolVersion1 == protocolVersion2) {
            return 0;
        }
        if (DataConverter.bytesToInt((byte[])protocolVersion1.getValue()) > DataConverter.bytesToInt((byte[])protocolVersion2.getValue())) {
            return 1;
        }
        return -1;
    }

    private static int compareDtls(ProtocolVersion protocolVersion1, ProtocolVersion protocolVersion2) {
        if (!protocolVersion1.isDTLS() || !protocolVersion2.isDTLS()) {
            throw new IllegalArgumentException("Can not compare " + protocolVersion1.toHumanReadable() + " and " + protocolVersion2.toHumanReadable() + " as DTLS versions");
        }
        if (protocolVersion1 == protocolVersion2) {
            return 0;
        }
        if (protocolVersion1.getMinor() < protocolVersion2.getMinor()) {
            return 1;
        }
        return -1;
    }

    public String toHumanReadable() {
        switch (this.ordinal()) {
            case 21: {
                return "DTLS Legacy";
            }
            case 22: {
                return "DTLS 1.0";
            }
            case 23: {
                return "DTLS 1.2";
            }
            case 24: {
                return "DTLS 1.3";
            }
            case 0: {
                return "SSL 2.0";
            }
            case 1: {
                return "SSL 3.0";
            }
            case 2: {
                return "TLS 1.0";
            }
            case 3: {
                return "TLS 1.1";
            }
            case 4: {
                return "TLS 1.2";
            }
            case 5: {
                return "TLS 1.3";
            }
            case 6: {
                return "TLS 1.3 Draft-14";
            }
            case 7: {
                return "TLS 1.3 Draft-15";
            }
            case 8: {
                return "TLS 1.3 Draft-16";
            }
            case 9: {
                return "TLS 1.3 Draft-17";
            }
            case 10: {
                return "TLS 1.3 Draft-18";
            }
            case 11: {
                return "TLS 1.3 Draft-19";
            }
            case 12: {
                return "TLS 1.3 Draft-20";
            }
            case 13: {
                return "TLS 1.3 Draft-21";
            }
            case 14: {
                return "TLS 1.3 Draft-22";
            }
            case 15: {
                return "TLS 1.3 Draft-23";
            }
            case 16: {
                return "TLS 1.3 Draft-24";
            }
            case 17: {
                return "TLS 1.3 Draft-25";
            }
            case 18: {
                return "TLS 1.3 Draft-26";
            }
            case 19: {
                return "TLS 1.3 Draft-27";
            }
            case 20: {
                return "TLS 1.3 Draft-28";
            }
        }
        return this.name();
    }

    static {
        MAP = new HashMap<Integer, ProtocolVersion>();
        for (ProtocolVersion c : ProtocolVersion.values()) {
            MAP.put(ProtocolVersion.valueToInt(c.value), c);
        }
    }
}

