/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.util;

import de.rub.nds.modifiablevariable.util.DataConverter;
import java.math.BigInteger;
import java.util.List;

public class MathHelper {
    public static BigInteger intFloorDiv(BigInteger c, BigInteger d) {
        return c.subtract(c.mod(d)).divide(d);
    }

    public static int intFloorDiv(int c, int d) {
        return (c - c % d) / d;
    }

    public static BigInteger intCeilDiv(BigInteger c, BigInteger d) {
        if (c.mod(d).equals(BigInteger.ZERO)) {
            return MathHelper.intFloorDiv(c, d);
        }
        return MathHelper.intFloorDiv(c, d).add(BigInteger.ONE);
    }

    public static int intCeilDiv(int c, int d) {
        if (c % d == 0) {
            return MathHelper.intFloorDiv(c, d);
        }
        return MathHelper.intFloorDiv(c, d) + 1;
    }

    public static BigIntegerTriple extendedEuclid(BigInteger u, BigInteger v) {
        BigInteger r = BigInteger.ONE;
        BigInteger s = BigInteger.ZERO;
        BigInteger c = u;
        BigInteger v1 = BigInteger.ZERO;
        BigInteger v2 = BigInteger.ONE;
        BigInteger v3 = v;
        while (!v3.equals(BigInteger.ZERO)) {
            BigInteger q = c.divide(v3);
            BigInteger t1 = r.subtract(q.multiply(v1));
            BigInteger t2 = s.subtract(q.multiply(v2));
            BigInteger t3 = c.subtract(q.multiply(v3));
            r = v1;
            s = v2;
            c = v3;
            v1 = t1;
            v2 = t2;
            v3 = t3;
        }
        return new BigIntegerTriple(c, r, s);
    }

    public static BigInteger gcd(BigInteger u, BigInteger v) {
        return MathHelper.extendedEuclid((BigInteger)u, (BigInteger)v).bigA;
    }

    public static BigInteger inverseMod(BigInteger a, BigInteger p) {
        if (!MathHelper.gcd(a, p).equals(BigInteger.ONE)) {
            throw new RuntimeException("does not exist");
        }
        BigInteger b = MathHelper.extendedEuclid((BigInteger)a, (BigInteger)p).bigB;
        while (b.compareTo(BigInteger.ZERO) < 0) {
            b = b.add(p);
        }
        return b;
    }

    public static BigInteger crt(BigInteger[] congs, BigInteger[] moduli) {
        BigInteger prodModuli = BigInteger.ONE;
        for (BigInteger mod : moduli) {
            prodModuli = prodModuli.multiply(mod);
        }
        BigInteger[] modulus = new BigInteger[moduli.length];
        for (int i = 0; i < moduli.length; ++i) {
            modulus[i] = prodModuli.divide(moduli[i]);
        }
        BigInteger retVal = BigInteger.ZERO;
        for (int i = 0; i < moduli.length; ++i) {
            BigInteger tmp = MathHelper.extendedEuclid((BigInteger)moduli[i], (BigInteger)modulus[i]).bigC;
            retVal = retVal.add(congs[i].multiply(tmp).multiply(modulus[i]).mod(prodModuli));
        }
        return retVal.mod(prodModuli);
    }

    public static BigInteger crt(List<BigInteger> congs, List<BigInteger> moduli) {
        BigInteger[] cs = DataConverter.convertListToArray(congs);
        BigInteger[] ms = DataConverter.convertListToArray(moduli);
        return MathHelper.crt(cs, ms);
    }

    public static BigInteger bigIntSqRootFloor(BigInteger x) throws IllegalArgumentException {
        if (x.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (x.equals(BigInteger.ZERO) || x.equals(BigInteger.ONE)) {
            return x;
        }
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger y = x.divide(two);
        while (y.compareTo(x.divide(y)) > 0) {
            y = x.divide(y).add(y).divide(two);
        }
        return y;
    }

    public static BigInteger bigIntSqRootCeil(BigInteger x) throws IllegalArgumentException {
        if (x.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Negative argument.");
        }
        if (x.equals(BigInteger.ZERO) || x.equals(BigInteger.ONE)) {
            return x;
        }
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger y = x.divide(two);
        while (y.compareTo(x.divide(y)) > 0) {
            y = x.divide(y).add(y).divide(two);
        }
        if (x.compareTo(y.multiply(y)) == 0) {
            return y;
        }
        return y.add(BigInteger.ONE);
    }

    private MathHelper() {
    }

    public static class BigIntegerTriple {
        private final BigInteger bigA;
        private final BigInteger bigB;
        private final BigInteger bigC;

        public BigIntegerTriple(BigInteger a, BigInteger b, BigInteger c) {
            this.bigA = a;
            this.bigB = b;
            this.bigC = c;
        }

        public BigInteger getBigA() {
            return this.bigA;
        }

        public BigInteger getBigB() {
            return this.bigB;
        }

        public BigInteger getBigC() {
            return this.bigC;
        }
    }
}

