/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.serializer;

import de.rub.nds.asn1.model.Asn1Choice;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.x509attacker.x509.serializer.X509Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509ChoiceSerializer<Choice extends Asn1Choice>
implements X509Serializer {
    private final Logger LOGGER = LogManager.getLogger();
    private final Choice choice;

    public X509ChoiceSerializer(Choice choice) {
        this.choice = choice;
    }

    @Override
    public byte[] serialize() {
        try (SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();){
            Asn1Encodable selectedChoice = this.choice.getSelectedChoice();
            outputStream.write((byte[])selectedChoice.getTagOctets().getValue());
            outputStream.write((byte[])selectedChoice.getLengthOctets().getValue());
            outputStream.write((byte[])selectedChoice.getContent().getValue());
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

