/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator.publickey;

import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.publickey.X509DsaPublicKey;
import de.rub.nds.x509attacker.x509.preparator.X509Asn1FieldPreparator;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509DsaPublicKeyPreparator
extends X509Asn1FieldPreparator<X509DsaPublicKey> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509DsaPublicKeyPreparator(X509DsaPublicKey instance, X509Chooser chooser) {
        super(chooser, instance);
    }

    protected byte[] encodeContent() {
        BigInteger publicKey = this.chooser.getSubjectDsaGenerator().modPow(this.chooser.getConfig().getDefaultIssuerDsaPrivateKey(), this.chooser.getSubjectDsaPrimeP());
        LOGGER.debug("Computed dsa public key as: {}", (Object)publicKey);
        Asn1PreparatorHelper.prepareField((Asn1Integer)((Asn1Integer)this.field), (BigInteger)publicKey);
        return publicKey.toByteArray();
    }
}

