/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayShuffleModification;
import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.crypto.key.DsaPrivateKey;
import de.rub.nds.protocol.crypto.key.EcdsaPrivateKey;
import de.rub.nds.protocol.crypto.key.PrivateKeyContainer;
import de.rub.nds.protocol.crypto.key.RsaPrivateKey;
import de.rub.nds.protocol.crypto.signature.RsaSsaPssSignatureComputations;
import de.rub.nds.protocol.crypto.signature.SignatureCalculator;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509SignatureAlgorithm;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import de.rub.nds.x509attacker.x509.preparator.X509ContainerPreparator;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509CertificatePreparator
extends X509ContainerPreparator<X509Certificate> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509CertificatePreparator(X509Chooser chooser, X509Certificate certificate) {
        super(chooser, certificate);
    }

    private void prepareTbsCertificate() {
        ((X509Certificate)this.field).getTbsCertificate().getPreparator(this.chooser).prepare();
        ((X509Certificate)this.field).getTbsCertificate().getHandler(this.chooser).adjustContextAfterPrepare();
    }

    private void prepareSignatureAlgorithmIdentifier() {
        ((X509Certificate)this.field).getSignatureAlgorithmIdentifier().getPreparator(this.chooser).prepare();
        ((X509Certificate)this.field).getSignatureAlgorithmIdentifier().getHandler(this.chooser).adjustContextAfterPrepare();
    }

    public void prepareSignature() {
        SignatureCalculator signatureCalculator = new SignatureCalculator();
        X509SignatureAlgorithm signatureAlgorithm = this.chooser.getSignatureAlgorithm();
        if (((X509Certificate)this.field).getSignatureComputations() == null) {
            ((X509Certificate)this.field).setSignatureComputations(signatureCalculator.createSignatureComputations(signatureAlgorithm.getSignatureAlgorithm()));
            if (signatureAlgorithm == X509SignatureAlgorithm.RSASSA_PSS) {
                ((RsaSsaPssSignatureComputations)((X509Certificate)this.field).getSignatureComputations()).setSalt(this.chooser.getRsaPssSalt());
            }
        }
        byte[] toBeSigned = ((X509Certificate)this.field).getTbsCertificate().getSerializer(this.chooser).serialize();
        LOGGER.debug("To be signed: {}", (Object)toBeSigned);
        HashAlgorithm hashAlgorithm = signatureAlgorithm == X509SignatureAlgorithm.RSASSA_PSS ? this.chooser.getRsaPssHashAlgorithm() : this.chooser.getSignatureAlgorithm().getHashAlgorithm();
        signatureCalculator.computeSignature(((X509Certificate)this.field).getSignatureComputations(), this.getPrivateKeyForAlgorithm(signatureAlgorithm.getSignatureAlgorithm()), toBeSigned, signatureAlgorithm.getSignatureAlgorithm(), hashAlgorithm);
        LOGGER.debug("Signature: {}", ((X509Certificate)this.field).getSignatureComputations().getSignatureBytes().getValue());
        if (this.chooser.getConfig().isSignatureInvalid()) {
            ((X509Certificate)this.field).getSignatureComputations().getSignatureBytes().addModification((VariableModification)new ByteArrayShuffleModification(new int[]{0, 1, 2, 3}));
        }
        if (this.chooser.getConfig().isSignatureEmpty()) {
            ((X509Certificate)this.field).getSignatureComputations().getSignatureBytes().addModification((VariableModification)new ByteArrayExplicitValueModification(new byte[0]));
        }
        Asn1PreparatorHelper.prepareField((Asn1BitString)((X509Certificate)this.field).getSignature(), (byte[])((byte[])((X509Certificate)this.field).getSignatureComputations().getSignatureBytes().getValue()), (byte)0);
    }

    private PrivateKeyContainer getPrivateKeyForAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        return switch (signatureAlgorithm) {
            case SignatureAlgorithm.ECDSA -> new EcdsaPrivateKey(this.chooser.getIssuerEcPrivateKey(), this.chooser.getConfig().getDefaultIssuerDsaNonce(), this.chooser.getSubjectNamedCurve().getParameters());
            case SignatureAlgorithm.RSA_PKCS1, SignatureAlgorithm.RSA_SSA_PSS -> new RsaPrivateKey(this.chooser.getIssuerRsaPrivateExponent(), this.chooser.getIssuerRsaModulus());
            case SignatureAlgorithm.DSA -> new DsaPrivateKey(this.chooser.getIssuerDsaPrimeQ(), this.chooser.getIssuerDsaPrivateKeyX(), this.chooser.getIssuerDsaPrivateK(), this.chooser.getIssuerDsaGenerator(), this.chooser.getIssuerDsaPrimeP());
            default -> throw new UnsupportedOperationException("The keytype \"" + signatureAlgorithm.name() + "\" is not implemented yet");
        };
    }

    @Override
    public void prepareSubComponents() {
        this.prepareTbsCertificate();
        this.prepareSignatureAlgorithmIdentifier();
        this.prepareSignature();
    }

    @Override
    public byte[] encodeChildrenContent() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(((X509Certificate)this.field).getTbsCertificate());
        children.add(((X509Certificate)this.field).getSignatureAlgorithmIdentifier());
        if (this.chooser.getConfig().isIncludeTbsSignature()) {
            children.add(((X509Certificate)this.field).getSignature());
        }
        return this.encodeChildren(children);
    }
}

