/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.publickey.parameters;

import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509EcNamedCurveParameters;
import de.rub.nds.x509attacker.x509.parser.X509ComponentParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509EcNamedCurveParametersParser
extends X509ComponentParser<X509EcNamedCurveParameters> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509EcNamedCurveParametersParser(X509Chooser chooser, X509EcNamedCurveParameters x509EcNamedCurveParameters) {
        super(chooser, x509EcNamedCurveParameters);
    }

    @Override
    public void parse(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing X509EcNamedCurveParameters");
        this.parseX509NamedCurveOid(inputStream);
    }

    private void parseX509NamedCurveOid(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1ObjectIdentifier((Asn1ObjectIdentifier)((Asn1ObjectIdentifier)this.encodable), (BufferedInputStream)inputStream);
        X509NamedCurve namedCurve = X509NamedCurve.decodeFromOidBytes(((X509EcNamedCurveParameters)this.encodable).getValueAsOid().getEncoded());
        LOGGER.debug("Parsed ObjectIdentidifier: {} ({})", ((X509EcNamedCurveParameters)this.encodable).getValue().getValue(), (Object)(namedCurve == null ? "unknown" : namedCurve.name()));
    }
}

